/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ftx.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.ftx.FtxAdapters;
import org.knowm.xchange.ftx.FtxException;
import org.knowm.xchange.ftx.dto.FtxResponse;
import org.knowm.xchange.ftx.dto.account.FtxPositionDto;
import org.knowm.xchange.ftx.dto.trade.CancelAllFtxOrdersParams;
import org.knowm.xchange.ftx.dto.trade.FtxModifyOrderRequestPayload;
import org.knowm.xchange.ftx.dto.trade.FtxOrderDto;
import org.knowm.xchange.ftx.dto.trade.FtxOrderRequestPayload;
import org.knowm.xchange.ftx.service.FtxBaseService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByUserReferenceParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.CurrencyPairParam;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamInstrument;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class FtxTradeServiceRaw
extends FtxBaseService {
    public FtxTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public String placeMarketOrderForSubaccount(String subaccount, MarketOrder marketOrder) throws IOException {
        return this.placeNewFtxOrder(subaccount, FtxAdapters.adaptMarketOrderToFtxOrderPayload(marketOrder)).getResult().getId();
    }

    public String placeLimitOrderForSubaccount(String subaccount, LimitOrder limitOrder) throws IOException {
        return this.placeNewFtxOrder(subaccount, FtxAdapters.adaptLimitOrderToFtxOrderPayload(limitOrder)).getResult().getId();
    }

    public FtxResponse<FtxOrderDto> placeNewFtxOrder(String subaccount, FtxOrderRequestPayload payload) throws FtxException, IOException {
        try {
            return this.ftx.placeOrder(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, payload);
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public FtxResponse<FtxOrderDto> modifyFtxOrder(String subaccount, String orderId, FtxModifyOrderRequestPayload payload) throws FtxException, IOException {
        return this.ftx.modifyOrder(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, orderId, payload);
    }

    public FtxResponse<FtxOrderDto> modifyFtxOrderByClientId(String subaccount, String clientId, FtxModifyOrderRequestPayload payload) throws FtxException, IOException {
        return this.ftx.modifyOrderByClientId(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, clientId, payload);
    }

    public boolean cancelOrderForSubaccount(String subaccount, String orderId) throws IOException {
        return this.cancelFtxOrder(subaccount, orderId);
    }

    public boolean cancelFtxOrder(String subaccount, String orderId) throws FtxException, IOException {
        try {
            return this.ftx.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, orderId).isSuccess();
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public boolean cancelFtxByClientId(String subaccount, String clientId) throws FtxException, IOException {
        try {
            return this.ftx.cancelOrderByClientId(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, clientId).isSuccess();
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public boolean cancelOrderForSubaccount(String subaccount, CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByCurrencyPair) {
            return this.cancelAllFtxOrders(subaccount, new CancelAllFtxOrdersParams(FtxAdapters.adaptCurrencyPairToFtxMarket(((CancelOrderByCurrencyPair)orderParams).getCurrencyPair())));
        }
        if (orderParams instanceof CancelOrderByUserReferenceParams) {
            return this.cancelFtxByClientId(subaccount, ((CancelOrderByUserReferenceParams)orderParams).getUserReference());
        }
        throw new IOException("CancelOrderParams must implement CancelOrderByCurrencyPair interface.");
    }

    public boolean cancelAllFtxOrders(String subaccount, CancelAllFtxOrdersParams payLoad) throws FtxException, IOException {
        try {
            return this.ftx.cancelAllOrders(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, payLoad).isSuccess();
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public Collection<Order> getOrderFromSubaccount(String subaccount, String ... orderIds) throws IOException {
        ArrayList<Order> orderList = new ArrayList<Order>();
        for (String orderId : orderIds) {
            LimitOrder order = FtxAdapters.adaptLimitOrder(this.getFtxOrderStatus(subaccount, orderId).getResult());
            orderList.add((Order)order);
        }
        return orderList;
    }

    public FtxResponse<List<FtxOrderDto>> getFtxOpenOrders(String subaccount, String market) throws FtxException, IOException {
        try {
            return this.ftx.openOrders(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, market);
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public UserTrades getTradeHistoryForSubaccount(String subaccount, TradeHistoryParams params) throws IOException {
        if (params instanceof TradeHistoryParamCurrencyPair) {
            return FtxAdapters.adaptUserTrades(this.getFtxOrderHistory(subaccount, FtxAdapters.adaptCurrencyPairToFtxMarket(((TradeHistoryParamCurrencyPair)params).getCurrencyPair())).getResult());
        }
        if (params instanceof TradeHistoryParamInstrument) {
            CurrencyPair currencyPair = new CurrencyPair(((TradeHistoryParamInstrument)params).getInstrument().toString());
            return FtxAdapters.adaptUserTrades(this.getFtxOrderHistory(subaccount, FtxAdapters.adaptCurrencyPairToFtxMarket(currencyPair)).getResult());
        }
        throw new IOException("TradeHistoryParams must implement TradeHistoryParamCurrencyPair or TradeHistoryParamInstrument interface.");
    }

    public FtxResponse<List<FtxOrderDto>> getFtxOrderHistory(String subaccount, String market) throws FtxException, IOException {
        try {
            return this.ftx.orderHistory(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, market);
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public OpenOrders getOpenOrdersForSubaccount(String subaccount) throws IOException {
        return FtxAdapters.adaptOpenOrders(this.getFtxAllOpenOrdersForSubaccount(subaccount));
    }

    public OpenOrders getOpenOrdersForSubaccount(String subaccount, OpenOrdersParams params) throws IOException {
        if (params instanceof CurrencyPairParam) {
            return FtxAdapters.adaptOpenOrders(this.getFtxOpenOrders(subaccount, FtxAdapters.adaptCurrencyPairToFtxMarket(((CurrencyPairParam)params).getCurrencyPair())));
        }
        throw new IOException("OpenOrdersParams must implement CurrencyPairParam interface.");
    }

    public FtxResponse<List<FtxOrderDto>> getFtxAllOpenOrdersForSubaccount(String subaccount) throws FtxException, IOException {
        try {
            return this.ftx.openOrdersWithoutMarket(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount);
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public FtxResponse<FtxOrderDto> getFtxOrderStatus(String subaccount, String orderId) throws FtxException, IOException {
        try {
            return this.ftx.getOrderStatus(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount, orderId);
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }

    public OpenPositions getOpenPositionsForSubaccount(String subaccount) throws IOException {
        return FtxAdapters.adaptOpenPositions(this.getFtxPositions(subaccount).getResult());
    }

    public FtxResponse<List<FtxPositionDto>> getFtxPositions(String subaccount) throws FtxException, IOException {
        try {
            return this.ftx.getFtxPositions(this.exchange.getExchangeSpecification().getApiKey(), (Long)this.exchange.getNonceFactory().createValue(), this.signatureCreator, subaccount);
        }
        catch (FtxException e) {
            throw new FtxException(e.getMessage());
        }
    }
}

