/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.FloatingRateLoanOrder;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.gemini.v1.dto.account.GeminiBalancesResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTrailingVolumeResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTransfer;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiDepth;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiLendLevel;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiLevel;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiTicker;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiTrade;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiOrderStatusResponse;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiTradeResponse;
import org.knowm.xchange.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeminiAdapters {
    public static final Logger log = LoggerFactory.getLogger(GeminiAdapters.class);

    private GeminiAdapters() {
    }

    public static List<CurrencyPair> adaptCurrencyPairs(Collection<String> GeminiSymbol) {
        ArrayList<CurrencyPair> currencyPairs = new ArrayList<CurrencyPair>();
        for (String symbol : GeminiSymbol) {
            currencyPairs.add(GeminiAdapters.adaptCurrencyPair(symbol));
        }
        return currencyPairs;
    }

    public static CurrencyPair adaptCurrencyPair(String GeminiSymbol) {
        String tradableIdentifier = GeminiSymbol.substring(0, 3).toUpperCase();
        String transactionCurrency = GeminiSymbol.substring(3).toUpperCase();
        return new CurrencyPair(tradableIdentifier, transactionCurrency);
    }

    public static String adaptCurrencyPair(CurrencyPair pair) {
        return (pair.base.getCurrencyCode() + pair.counter.getCurrencyCode()).toLowerCase();
    }

    public static OrderBook adaptOrderBook(GeminiDepth btceDepth, CurrencyPair currencyPair) {
        OrdersContainer asksOrdersContainer = GeminiAdapters.adaptOrders(btceDepth.getAsks(), currencyPair, Order.OrderType.ASK);
        OrdersContainer bidsOrdersContainer = GeminiAdapters.adaptOrders(btceDepth.getBids(), currencyPair, Order.OrderType.BID);
        return new OrderBook(new Date(Math.max(asksOrdersContainer.getTimestamp(), bidsOrdersContainer.getTimestamp())), asksOrdersContainer.getLimitOrders(), bidsOrdersContainer.getLimitOrders());
    }

    public static OrdersContainer adaptOrders(GeminiLevel[] GeminiLevels, CurrencyPair currencyPair, Order.OrderType orderType) {
        BigDecimal maxTimestamp = new BigDecimal(Long.MIN_VALUE);
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(GeminiLevels.length);
        for (GeminiLevel GeminiLevel2 : GeminiLevels) {
            if (GeminiLevel2.getTimestamp().compareTo(maxTimestamp) > 0) {
                maxTimestamp = GeminiLevel2.getTimestamp();
            }
            Date timestamp = GeminiAdapters.convertBigDecimalTimestampToDate(GeminiLevel2.getTimestamp());
            limitOrders.add(GeminiAdapters.adaptOrder(GeminiLevel2.getAmount(), GeminiLevel2.getPrice(), currencyPair, orderType, timestamp));
        }
        long maxTimestampInMillis = maxTimestamp.multiply(new BigDecimal(1000L)).longValue();
        return new OrdersContainer(maxTimestampInMillis, limitOrders);
    }

    public static Order adaptOrder(GeminiOrderStatusResponse geminiOrderStatusResponse) {
        Long id = geminiOrderStatusResponse.getId();
        CurrencyPair currencyPair = GeminiAdapters.adaptCurrencyPair(geminiOrderStatusResponse.getSymbol());
        BigDecimal averageExecutionPrice = geminiOrderStatusResponse.getAvgExecutionPrice();
        BigDecimal executedAmount = geminiOrderStatusResponse.getExecutedAmount();
        BigDecimal originalAmount = geminiOrderStatusResponse.getOriginalAmount();
        Order.OrderType orderType = geminiOrderStatusResponse.getSide().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        Order.OrderStatus orderStatus = GeminiAdapters.adaptOrderstatus(geminiOrderStatusResponse);
        Date timestamp = new Date(geminiOrderStatusResponse.getTimestampms() / 1000L);
        if (geminiOrderStatusResponse.getType().contains("limit")) {
            BigDecimal limitPrice = geminiOrderStatusResponse.getPrice();
            return new LimitOrder(orderType, originalAmount, currencyPair, id.toString(), timestamp, limitPrice, averageExecutionPrice, executedAmount, null, orderStatus);
        }
        if (geminiOrderStatusResponse.getType().contains("market")) {
            return new MarketOrder(orderType, originalAmount, currencyPair, id.toString(), timestamp, averageExecutionPrice, executedAmount, null, orderStatus);
        }
        throw new NotYetImplementedForExchangeException();
    }

    private static Order.OrderStatus adaptOrderstatus(GeminiOrderStatusResponse geminiOrderStatusResponse) {
        if (geminiOrderStatusResponse.isCancelled()) {
            return Order.OrderStatus.CANCELED;
        }
        if (geminiOrderStatusResponse.getRemainingAmount().equals(new BigDecimal(0.0))) {
            return Order.OrderStatus.FILLED;
        }
        if (geminiOrderStatusResponse.getRemainingAmount().compareTo(new BigDecimal(0.0)) > 0) {
            return Order.OrderStatus.PARTIALLY_FILLED;
        }
        throw new NotYetImplementedForExchangeException();
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, CurrencyPair currencyPair, Order.OrderType orderType, Date timestamp) {
        return new LimitOrder(orderType, amount, currencyPair, "", timestamp, price);
    }

    public static List<FixedRateLoanOrder> adaptFixedRateLoanOrders(GeminiLendLevel[] orders, String currency, String orderType, String id) {
        ArrayList<FixedRateLoanOrder> loanOrders = new ArrayList<FixedRateLoanOrder>(orders.length);
        for (GeminiLendLevel order : orders) {
            if ("yes".equalsIgnoreCase(order.getFrr())) continue;
            if (orderType.equalsIgnoreCase("loan")) {
                loanOrders.add(0, GeminiAdapters.adaptFixedRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
                continue;
            }
            loanOrders.add(GeminiAdapters.adaptFixedRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
        }
        return loanOrders;
    }

    public static FixedRateLoanOrder adaptFixedRateLoanOrder(String currency, BigDecimal amount, int dayPeriod, String direction, String id, BigDecimal rate) {
        Order.OrderType orderType = direction.equalsIgnoreCase("loan") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new FixedRateLoanOrder(orderType, currency, amount, dayPeriod, id, null, rate);
    }

    public static List<FloatingRateLoanOrder> adaptFloatingRateLoanOrders(GeminiLendLevel[] orders, String currency, String orderType, String id) {
        ArrayList<FloatingRateLoanOrder> loanOrders = new ArrayList<FloatingRateLoanOrder>(orders.length);
        for (GeminiLendLevel order : orders) {
            if ("no".equals(order.getFrr())) continue;
            if (orderType.equalsIgnoreCase("loan")) {
                loanOrders.add(0, GeminiAdapters.adaptFloatingRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
                continue;
            }
            loanOrders.add(GeminiAdapters.adaptFloatingRateLoanOrder(currency, order.getAmount(), order.getPeriod(), orderType, id, order.getRate()));
        }
        return loanOrders;
    }

    public static FloatingRateLoanOrder adaptFloatingRateLoanOrder(String currency, BigDecimal amount, int dayPeriod, String direction, String id, BigDecimal rate) {
        Order.OrderType orderType = direction.equalsIgnoreCase("loan") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new FloatingRateLoanOrder(orderType, currency, amount, dayPeriod, id, null, rate);
    }

    public static Trade adaptTrade(GeminiTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = trade.getType().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getAmount();
        BigDecimal price = trade.getPrice();
        Date date = DateUtils.fromMillisUtc((long)(trade.getTimestamp() * 1000L));
        String tradeId = String.valueOf(trade.getTradeId());
        return new Trade.Builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(date).id(tradeId).build();
    }

    public static Trades adaptTrades(GeminiTrade[] trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.length);
        long lastTradeId = 0L;
        for (GeminiTrade trade : trades) {
            long tradeId = trade.getTradeId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(GeminiAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Ticker adaptTicker(GeminiTicker GeminiTicker2, CurrencyPair currencyPair) {
        BigDecimal last = GeminiTicker2.getLast();
        BigDecimal bid = GeminiTicker2.getBid();
        BigDecimal ask = GeminiTicker2.getAsk();
        BigDecimal volume = GeminiTicker2.getVolume().getBaseVolume(currencyPair);
        Date timestamp = DateUtils.fromMillisUtc((long)GeminiTicker2.getVolume().getTimestampMS());
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).volume(volume).timestamp(timestamp).build();
    }

    public static Wallet adaptWallet(GeminiBalancesResponse[] response) {
        HashMap<String, BigDecimal[]> balancesByCurrency = new HashMap<String, BigDecimal[]>();
        for (GeminiBalancesResponse balance : response) {
            String currencyName = balance.getCurrency().toUpperCase();
            BigDecimal[] balanceDetail = (BigDecimal[])balancesByCurrency.get(currencyName);
            if (balanceDetail == null) {
                balanceDetail = new BigDecimal[]{balance.getAmount(), balance.getAvailable()};
            } else {
                balanceDetail[0] = balanceDetail[0].add(balance.getAmount());
                balanceDetail[1] = balanceDetail[1].add(balance.getAvailable());
            }
            balancesByCurrency.put(currencyName, balanceDetail);
        }
        ArrayList<Balance> balances = new ArrayList<Balance>(balancesByCurrency.size());
        for (Map.Entry entry : balancesByCurrency.entrySet()) {
            String currencyName = (String)entry.getKey();
            BigDecimal[] balanceDetail = (BigDecimal[])entry.getValue();
            BigDecimal balanceTotal = balanceDetail[0];
            BigDecimal balanceAvailable = balanceDetail[1];
            balances.add(new Balance(Currency.getInstance((String)currencyName), balanceTotal, balanceAvailable));
        }
        return Wallet.Builder.from(balances).build();
    }

    public static OpenOrders adaptOrders(GeminiOrderStatusResponse[] activeOrders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(activeOrders.length);
        for (GeminiOrderStatusResponse order : activeOrders) {
            Order.OrderType orderType = order.getSide().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            CurrencyPair currencyPair = GeminiAdapters.adaptCurrencyPair(order.getSymbol());
            Date timestamp = GeminiAdapters.convertBigDecimalTimestampToDate(new BigDecimal(order.getTimestamp()));
            Order.OrderStatus status = Order.OrderStatus.NEW;
            if (order.isCancelled()) {
                status = Order.OrderStatus.CANCELED;
            } else if (order.getExecutedAmount().signum() > 0 && order.getExecutedAmount().compareTo(order.getOriginalAmount()) < 0) {
                status = Order.OrderStatus.PARTIALLY_FILLED;
            } else if (order.getExecutedAmount().compareTo(order.getOriginalAmount()) == 0) {
                status = Order.OrderStatus.FILLED;
            }
            LimitOrder limitOrder = new LimitOrder(orderType, order.getOriginalAmount(), currencyPair, String.valueOf(order.getId()), timestamp, order.getPrice(), order.getAvgExecutionPrice(), order.getExecutedAmount(), null, status);
            limitOrders.add(limitOrder);
        }
        return new OpenOrders(limitOrders);
    }

    public static UserTrades adaptTradeHistory(GeminiTradeResponse[] trades, String symbol) {
        ArrayList<UserTrade> pastTrades = new ArrayList<UserTrade>(trades.length);
        CurrencyPair currencyPair = GeminiAdapters.adaptCurrencyPair(symbol);
        for (GeminiTradeResponse trade : trades) {
            Order.OrderType orderType = trade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            Date timestamp = GeminiAdapters.convertBigDecimalTimestampToDate(trade.getTimestamp());
            BigDecimal fee = trade.getFeeAmount();
            pastTrades.add(new UserTrade.Builder().type(orderType).originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(timestamp).id(trade.getTradeId()).orderId(trade.getOrderId()).feeAmount(fee).feeCurrency(Currency.getInstance((String)trade.getFeeCurrency())).build());
        }
        return new UserTrades(pastTrades, Trades.TradeSortType.SortByTimestamp);
    }

    private static Date convertBigDecimalTimestampToDate(BigDecimal timestampInSeconds) {
        return new Date((long)Math.floor(timestampInSeconds.doubleValue() * 1000.0));
    }

    public static ExchangeMetaData adaptMetaData(List<CurrencyPair> currencyPairs, ExchangeMetaData metaData) {
        Map pairsMap = metaData.getCurrencyPairs();
        Map currenciesMap = metaData.getCurrencies();
        for (CurrencyPair c : currencyPairs) {
            if (!pairsMap.containsKey(c)) {
                pairsMap.put(c, null);
            }
            if (!currenciesMap.containsKey(c.base)) {
                currenciesMap.put(c.base, null);
            }
            if (currenciesMap.containsKey(c.counter)) continue;
            currenciesMap.put(c.counter, null);
        }
        return metaData;
    }

    public static Map<CurrencyPair, Fee> AdaptDynamicTradingFees(GeminiTrailingVolumeResponse volumeResponse, List<CurrencyPair> currencyPairs) {
        Hashtable<CurrencyPair, Fee> result = new Hashtable<CurrencyPair, Fee>();
        BigDecimal bpsToFraction = BigDecimal.ONE.divide(BigDecimal.ONE.scaleByPowerOfTen(4), 4, RoundingMode.HALF_EVEN);
        Fee feeAcrossCurrencies = new Fee(volumeResponse.apiMakerFeeBPS.multiply(bpsToFraction), volumeResponse.apiTakerFeeBPS.multiply(bpsToFraction));
        for (CurrencyPair currencyPair : currencyPairs) {
            result.put(currencyPair, feeAcrossCurrencies);
        }
        return result;
    }

    public static FundingRecord adapt(GeminiTransfer transfer) {
        FundingRecord.Status status = FundingRecord.Status.PROCESSING;
        if (transfer.status.equals("Complete")) {
            status = FundingRecord.Status.COMPLETE;
        }
        if (transfer.status.equals("Advanced")) {
            status = FundingRecord.Status.COMPLETE;
        }
        String description = "";
        if (transfer.purpose != null) {
            description = transfer.purpose;
        }
        if (transfer.method != null) {
            description = description + " " + transfer.method;
        }
        description = description.trim();
        FundingRecord.Type type = transfer.type.equals("Withdrawal") ? FundingRecord.Type.WITHDRAWAL : FundingRecord.Type.DEPOSIT;
        return new FundingRecord.Builder().setStatus(status).setType(type).setInternalId(transfer.eid).setAddress(transfer.destination).setCurrency(Currency.getInstance((String)transfer.currency)).setDate(DateUtils.fromMillisUtc((long)transfer.timestamp)).setAmount(transfer.amount).setBlockchainTransactionHash(transfer.txnHash).setDescription(description).build();
    }

    public static class OrdersContainer {
        private final long timestamp;
        private final List<LimitOrder> limitOrders;

        public OrdersContainer(long timestamp, List<LimitOrder> limitOrders) {
            this.timestamp = timestamp;
            this.limitOrders = limitOrders;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<LimitOrder> getLimitOrders() {
            return this.limitOrders;
        }
    }
}

