/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.gemini.v1.GeminiAdapters;
import org.knowm.xchange.gemini.v1.service.GeminiAccountService;
import org.knowm.xchange.gemini.v1.service.GeminiMarketDataService;
import org.knowm.xchange.gemini.v1.service.GeminiMarketDataServiceRaw;
import org.knowm.xchange.gemini.v1.service.GeminiTradeService;
import org.knowm.xchange.utils.nonce.AtomicLongCurrentTimeIncrementalNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class GeminiExchange
extends BaseExchange {
    private SynchronizedValueFactory<Long> nonceFactory = new AtomicLongCurrentTimeIncrementalNonceFactory();

    protected void initServices() {
        GeminiExchange.concludeHostParams(this.exchangeSpecification);
        this.marketDataService = new GeminiMarketDataService((Exchange)this);
        this.accountService = new GeminiAccountService((Exchange)this);
        this.tradeService = new GeminiTradeService((Exchange)this);
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        GeminiExchange.concludeHostParams(exchangeSpecification);
    }

    private static void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null && exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox").equals(true)) {
            exchangeSpecification.setSslUri("https://api.sandbox.gemini.com");
            exchangeSpecification.setHost("api.sandbox.gemini.com");
        }
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://api.Gemini.com/");
        exchangeSpecification.setHost("api.Gemini.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Gemini");
        exchangeSpecification.setExchangeDescription("Gemini is a bitcoin exchange.");
        exchangeSpecification.setExchangeSpecificParametersItem("Use_Sandbox", (Object)false);
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public void remoteInit() throws IOException, ExchangeException {
        GeminiMarketDataServiceRaw dataService = (GeminiMarketDataServiceRaw)this.marketDataService;
        List<CurrencyPair> currencyPairs = dataService.getExchangeSymbols();
        this.exchangeMetaData = GeminiAdapters.adaptMetaData(currencyPairs, this.exchangeMetaData);
    }
}

