/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.gemini.v1.GeminiAdapters;
import org.knowm.xchange.gemini.v1.dto.account.GeminiDepositAddressResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTrailingVolumeResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTransfer;
import org.knowm.xchange.gemini.v1.service.GeminiAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class GeminiAccountService
extends GeminiAccountServiceRaw
implements AccountService {
    public GeminiAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{GeminiAdapters.adaptWallet(this.getGeminiAccountInfo())});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdraw(currency, amount, address);
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        GeminiDepositAddressResponse response = super.requestDepositAddressRaw(currency);
        return response.getAddress();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        Date since = null;
        Integer limit = 50;
        if (params instanceof TradeHistoryParamLimit) {
            limit = ((TradeHistoryParamLimit)params).getLimit();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            since = ((TradeHistoryParamsTimeSpan)params).getStartTime();
        }
        ArrayList<FundingRecord> results = new ArrayList<FundingRecord>();
        for (GeminiTransfer transfer : this.transfers(since, limit)) {
            results.add(GeminiAdapters.adapt(transfer));
        }
        return results;
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        GeminiTrailingVolumeResponse volumes = this.Get30DayTrailingVolumeDescription();
        return GeminiAdapters.AdaptDynamicTradingFees(volumes, this.allCurrencyPairs);
    }
}

