/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.gemini.v1.GeminiAdapters;
import org.knowm.xchange.gemini.v1.dto.GeminiException;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiDepth;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiLend;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiLendDepth;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiTicker;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiTrade;
import org.knowm.xchange.gemini.v1.service.GeminiBaseService;

public class GeminiMarketDataServiceRaw
extends GeminiBaseService {
    public GeminiMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public GeminiTicker getGeminiTicker(String pair) throws IOException {
        try {
            GeminiTicker GeminiTicker2 = this.gemini.getTicker(pair);
            return GeminiTicker2;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiDepth getGeminiOrderBook(String pair, Integer limitBids, Integer limitAsks) throws IOException {
        try {
            GeminiDepth GeminiDepth2 = limitBids == null && limitAsks == null ? this.gemini.getBook(pair) : this.gemini.getBook(pair, limitBids, limitAsks);
            return GeminiDepth2;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiLendDepth getGeminiLendBook(String currency, int limitBids, int limitAsks) throws IOException {
        try {
            GeminiLendDepth GeminiLendDepth2 = this.gemini.getLendBook(currency, limitBids, limitAsks);
            return GeminiLendDepth2;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiTrade[] getGeminiTrades(String pair, long sinceTimestamp, int limitTrades) throws IOException {
        try {
            GeminiTrade[] GeminiTrades = this.gemini.getTrades(pair, sinceTimestamp, limitTrades);
            return GeminiTrades;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiLend[] getGeminiLends(String currency, long sinceTimestamp, int limitTrades) throws IOException {
        try {
            GeminiLend[] GeminiLends = this.gemini.getLends(currency, sinceTimestamp, limitTrades);
            return GeminiLends;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public Collection<String> getGeminiSymbols() throws IOException {
        try {
            return this.gemini.getSymbols();
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public List<CurrencyPair> getExchangeSymbols() throws IOException {
        try {
            ArrayList<CurrencyPair> currencyPairs = new ArrayList<CurrencyPair>();
            for (String symbol : this.gemini.getSymbols()) {
                currencyPairs.add(GeminiAdapters.adaptCurrencyPair(symbol));
            }
            return currencyPairs;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }
}

