/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class GeminiTransfersRequest {
    @JsonProperty(value="request")
    public final String request = "/v1/transfers";
    @JsonProperty(value="nonce")
    public final String nonce;
    @JsonProperty(value="limit_transfers")
    public final Integer limit;
    @JsonProperty(value="timestamp")
    public final Long timestamp;

    public GeminiTransfersRequest(String nonce, Integer limit, Long timestamp) {
        this.nonce = nonce;
        this.limit = limit;
        this.timestamp = timestamp;
    }

    public static GeminiTransfersRequest create(Date from, Integer limit, SynchronizedValueFactory<Long> nonceFactory) {
        Long timestamp = DateUtils.toMillisNullSafe((Date)from);
        return new GeminiTransfersRequest(String.valueOf(nonceFactory.createValue()), limit, timestamp);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getRequest() {
        return "/v1/transfers";
    }

    public String getNonce() {
        return this.nonce;
    }

    public Integer getLimit() {
        return this.limit;
    }
}

