/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.dto.trade;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GeminiOrderStatusResponse {
    private final long id;
    private final String clientOrderId;
    private final String exchange;
    private final String symbol;
    private final BigDecimal price;
    private final BigDecimal avgExecutionPrice;
    private final String side;
    private final String type;
    private final String timestamp;
    private final long timestampms;
    private final boolean isLive;
    private final boolean isCancelled;
    private final boolean wasForced;
    private final BigDecimal originalAmount;
    private final BigDecimal remainingAmount;
    private final BigDecimal executedAmount;
    private final OrderStatusTradeDetails[] trades;

    public GeminiOrderStatusResponse(@JsonProperty(value="order_id") long id, @JsonProperty(value="client_order_id") String clientOrderId, @JsonProperty(value="exchange") String exchange, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="avg_execution_price") BigDecimal avgExecutionPrice, @JsonProperty(value="side") String side, @JsonProperty(value="type") String type, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="timestampms") long timestampms, @JsonProperty(value="is_live") boolean isLive, @JsonProperty(value="is_cancelled") boolean isCancelled, @JsonProperty(value="was_forced") boolean wasForced, @JsonProperty(value="original_amount") BigDecimal originalAmount, @JsonProperty(value="remaining_amount") BigDecimal remainingAmount, @JsonProperty(value="executed_amount") BigDecimal executedAmount, @JsonProperty(value="trades") OrderStatusTradeDetails[] trades) {
        this.id = id;
        this.clientOrderId = clientOrderId;
        this.exchange = exchange;
        this.symbol = symbol;
        this.price = price;
        this.avgExecutionPrice = avgExecutionPrice;
        this.side = side;
        this.type = type;
        this.timestamp = timestamp;
        this.timestampms = timestampms;
        this.isLive = isLive;
        this.isCancelled = isCancelled;
        this.wasForced = wasForced;
        this.originalAmount = originalAmount;
        this.remainingAmount = remainingAmount;
        this.executedAmount = executedAmount;
        this.trades = trades;
    }

    public OrderStatusTradeDetails[] getTrades() {
        return this.trades;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeminiOrderStatusResponse [id=");
        builder.append(this.id);
        builder.append(", symbol=");
        builder.append(this.symbol);
        builder.append(", price=");
        builder.append(this.price);
        builder.append(", avgExecutionPrice=");
        builder.append(this.avgExecutionPrice);
        builder.append(", side=");
        builder.append(this.side);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", timestamp=");
        builder.append(this.timestamp);
        builder.append(", isLive=");
        builder.append(this.isLive);
        builder.append(", isCancelled=");
        builder.append(this.isCancelled);
        builder.append(", wasForced=");
        builder.append(this.wasForced);
        builder.append(", originalAmount=");
        builder.append(this.originalAmount);
        builder.append(", remainingAmount=");
        builder.append(this.remainingAmount);
        builder.append(", executedAmount=");
        builder.append(this.executedAmount);
        builder.append("]");
        return builder.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAvgExecutionPrice() {
        return this.avgExecutionPrice;
    }

    public String getSide() {
        return this.side;
    }

    public String getType() {
        return this.type;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public long getTimestampms() {
        return this.timestampms;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isWasForced() {
        return this.wasForced;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public BigDecimal getRemainingAmount() {
        return this.remainingAmount;
    }

    public BigDecimal getExecutedAmount() {
        return this.executedAmount;
    }

    public static class OrderStatusTradeDetails {
        private BigDecimal price;
        private BigDecimal amount;
        private String timestamp;
        private String timestampms;
        private String type;
        private boolean aggressor;
        private String feeCurrency;
        private BigDecimal feeAmount;
        private long tradeId;
        private String orderId;
        private String clientOrderId;
        private String exchange;
        private boolean isAuctionFill;
        private String Break;

        public OrderStatusTradeDetails(@JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="timestampms") String timestampms, @JsonProperty(value="type") String type, @JsonProperty(value="aggressor") boolean aggressor, @JsonProperty(value="fee_currency") String feeCurrency, @JsonProperty(value="fee_amount") String feeAmount, @JsonProperty(value="tid") long tradeId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="client_order_id") String clientOrderId, @JsonProperty(value="exchange") String exchange, @JsonProperty(value="is_auction_fill") boolean isAuctionFill, @JsonProperty(value="break") String Break) {
            this.price = price;
            this.amount = amount;
            this.timestamp = timestamp;
            this.timestampms = timestampms;
            this.type = type;
            this.aggressor = aggressor;
            this.feeCurrency = feeCurrency;
            this.feeAmount = new BigDecimal(feeAmount);
            this.tradeId = tradeId;
            this.orderId = orderId;
            this.clientOrderId = clientOrderId;
            this.exchange = exchange;
            this.isAuctionFill = isAuctionFill;
            this.Break = Break;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getTimestampms() {
            return this.timestampms;
        }

        public String getType() {
            return this.type;
        }

        public boolean isAggressor() {
            return this.aggressor;
        }

        public String getFeeCurrency() {
            return this.feeCurrency;
        }

        public BigDecimal getFeeAmount() {
            return this.feeAmount;
        }

        public long getTradeId() {
            return this.tradeId;
        }

        public String getOrderId() {
            return this.orderId;
        }

        public String getClientOrderId() {
            return this.clientOrderId;
        }

        public String getExchange() {
            return this.exchange;
        }

        public boolean isAuctionFill() {
            return this.isAuctionFill;
        }

        public String getBreak() {
            return this.Break;
        }
    }
}

