/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.gemini.v1.GeminiAdapters;
import org.knowm.xchange.gemini.v1.GeminiOrderType;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiLimitOrder;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiOrderStatusResponse;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiTradeResponse;
import org.knowm.xchange.gemini.v1.service.GeminiTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.DateUtils;

public class GeminiTradeService
extends GeminiTradeServiceRaw
implements TradeService {
    private static final OpenOrders noOpenOrders = new OpenOrders(new ArrayList());

    public GeminiTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        GeminiOrderStatusResponse[] activeOrders = this.getGeminiOpenOrders();
        if (activeOrders.length <= 0) {
            return noOpenOrders;
        }
        return GeminiAdapters.adaptOrders(activeOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        GeminiOrderStatusResponse newOrder = this.placeGeminiLimitOrder(limitOrder, GeminiOrderType.LIMIT);
        if (limitOrder instanceof GeminiLimitOrder) {
            GeminiLimitOrder raw = (GeminiLimitOrder)limitOrder;
            raw.setResponse(newOrder);
        }
        return String.valueOf(newOrder.getId());
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelGeminiOrder(orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Integer limit;
        long timestamp;
        if (!(params instanceof TradeHistoryParamCurrencyPair) || ((TradeHistoryParamCurrencyPair)params).getCurrencyPair() == null) {
            throw new ExchangeException("CurrencyPair must be supplied");
        }
        String symbol = GeminiAdapters.adaptCurrencyPair(((TradeHistoryParamCurrencyPair)params).getCurrencyPair());
        if (params instanceof TradeHistoryParamsTimeSpan) {
            Date startTime = ((TradeHistoryParamsTimeSpan)params).getStartTime();
            timestamp = DateUtils.toUnixTime((Date)startTime);
        } else {
            timestamp = 0L;
        }
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging pagingParams = (TradeHistoryParamPaging)params;
            Integer pageLength = pagingParams.getPageLength();
            Integer pageNum = pagingParams.getPageNumber();
            limit = pageLength != null && pageNum != null ? pageLength * (pageNum + 1) : 50;
        } else {
            limit = 50;
        }
        if (params instanceof TradeHistoryParamLimit) {
            limit = ((TradeHistoryParamLimit)params).getLimit();
        }
        GeminiTradeResponse[] trades = this.getGeminiTradeHistory(symbol, timestamp, limit);
        return GeminiAdapters.adaptTradeHistory(trades, symbol);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new GeminiTradeHistoryParams(CurrencyPair.BTC_USD, 500, new Date(0L));
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        ArrayList<Order> orders = new ArrayList<Order>(orderIds.length);
        for (String orderId : orderIds) {
            orders.add(GeminiAdapters.adaptOrder(super.getGeminiOrderStatus(orderId)));
        }
        return orders;
    }

    public static class GeminiTradeHistoryParams
    implements TradeHistoryParamCurrencyPair,
    TradeHistoryParamLimit,
    TradeHistoryParamsTimeSpan {
        private CurrencyPair currencyPair;
        private Integer limit;
        private Date startTime;

        public GeminiTradeHistoryParams(CurrencyPair currencyPair, Integer limit, Date startTime) {
            this.currencyPair = currencyPair;
            this.limit = limit;
            this.startTime = startTime;
        }

        public GeminiTradeHistoryParams() {
        }

        public CurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }

        public void setCurrencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return null;
        }

        public void setEndTime(Date endTime) {
        }
    }
}

