/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.gemini.v1.GeminiOrderType;
import org.knowm.xchange.gemini.v1.GeminiUtils;
import org.knowm.xchange.gemini.v1.dto.GeminiException;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiCancelOrderRequest;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiNewOrderRequest;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiNonceOnlyRequest;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiOrderFlags;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiOrderStatusRequest;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiOrderStatusResponse;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiPastTradesRequest;
import org.knowm.xchange.gemini.v1.dto.trade.GeminiTradeResponse;
import org.knowm.xchange.gemini.v1.service.GeminiBaseService;

public class GeminiTradeServiceRaw
extends GeminiBaseService {
    public GeminiTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public GeminiOrderStatusResponse[] getGeminiOpenOrders() throws IOException {
        try {
            GeminiOrderStatusResponse[] activeOrders = this.gemini.activeOrders(this.apiKey, this.payloadCreator, this.signatureCreator, new GeminiNonceOnlyRequest("/v1/orders", String.valueOf(this.exchange.getNonceFactory().createValue())));
            return activeOrders;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiOrderStatusResponse placeGeminiLimitOrder(LimitOrder limitOrder, GeminiOrderType GeminiOrderType2) throws IOException {
        Object[] options;
        String pair = GeminiUtils.toPairString(limitOrder.getCurrencyPair());
        String type = limitOrder.getType().equals((Object)Order.OrderType.BID) ? "buy" : "sell";
        String orderType = GeminiOrderType2.toString();
        Set flags = limitOrder.getOrderFlags();
        if (flags.isEmpty()) {
            options = null;
        } else {
            ArrayList<String> list = new ArrayList<String>();
            if (flags.contains((Object)GeminiOrderFlags.IMMEDIATE_OR_CANCEL)) {
                list.add("immediate-or-cancel");
            }
            if (flags.contains((Object)GeminiOrderFlags.POST_ONLY)) {
                list.add("maker-or-cancel");
            }
            if (flags.contains((Object)GeminiOrderFlags.FILL_OR_KILL)) {
                list.add("fill-or-kill");
            }
            if (flags.contains((Object)GeminiOrderFlags.AUCTION_ONLY)) {
                list.add("auction-only");
            }
            if (flags.contains((Object)GeminiOrderFlags.INDICATION_OF_INTEREST)) {
                list.add("indication-of-interest");
            }
            options = list.toArray();
        }
        GeminiNewOrderRequest request = new GeminiNewOrderRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), limitOrder.getUserReference(), pair, limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), "Gemini", type, orderType, options);
        try {
            GeminiOrderStatusResponse newOrder = this.gemini.newOrder(this.apiKey, this.payloadCreator, this.signatureCreator, request);
            return newOrder;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public boolean cancelGeminiOrder(String orderId) throws IOException {
        try {
            this.gemini.cancelOrders(this.apiKey, this.payloadCreator, this.signatureCreator, new GeminiCancelOrderRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), Long.valueOf(orderId)));
            return true;
        }
        catch (GeminiException e) {
            if (e.getMessage().equals("Order could not be cancelled.")) {
                return false;
            }
            throw this.handleException(e);
        }
    }

    public GeminiOrderStatusResponse getGeminiOrderStatus(String orderId) throws IOException {
        try {
            GeminiOrderStatusResponse orderStatus = this.gemini.orderStatus(this.apiKey, this.payloadCreator, this.signatureCreator, new GeminiOrderStatusRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), Long.valueOf(orderId)));
            return orderStatus;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiTradeResponse[] getGeminiTradeHistory(String symbol, long timestamp, Integer limit) throws IOException {
        try {
            GeminiTradeResponse[] trades = this.gemini.pastTrades(this.apiKey, this.payloadCreator, this.signatureCreator, new GeminiPastTradesRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), symbol, timestamp, limit));
            return trades;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }
}

