/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.FeeTier;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.hitbtc.v2.HitbtcExchange;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcBalance;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcLimitOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderBook;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderLimit;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOwnTrade;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSide;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSymbol;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTicker;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTrade;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransaction;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcUserTrade;
import org.knowm.xchange.hitbtc.v2.service.HitbtcMarketDataServiceRaw;

public class HitbtcAdapters {
    private static Map<String, CurrencyPair> symbols = new HashMap<String, CurrencyPair>();

    public static CurrencyPair adaptSymbol(String symbol) {
        if (symbols.isEmpty()) {
            try {
                HitbtcExchange exchange = (HitbtcExchange)ExchangeFactory.INSTANCE.createExchange(HitbtcExchange.class);
                symbols = new HitbtcMarketDataServiceRaw(exchange).getHitbtcSymbols().stream().collect(Collectors.toMap(hitbtcSymbol -> hitbtcSymbol.getBaseCurrency() + hitbtcSymbol.getQuoteCurrency(), hitbtcSymbol -> new CurrencyPair(hitbtcSymbol.getBaseCurrency(), hitbtcSymbol.getQuoteCurrency())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return symbols.containsKey(symbol) ? symbols.get(symbol) : HitbtcAdapters.guessSymbol(symbol);
    }

    static CurrencyPair guessSymbol(String symbol) {
        int splitIndex = symbol.endsWith("USDT") ? symbol.lastIndexOf("USDT") : symbol.length() - 3;
        return new CurrencyPair(symbol.substring(0, splitIndex), symbol.substring(splitIndex));
    }

    public static CurrencyPair adaptSymbol(HitbtcSymbol hitbtcSymbol) {
        return new CurrencyPair(hitbtcSymbol.getBaseCurrency(), hitbtcSymbol.getQuoteCurrency());
    }

    public static Ticker adaptTicker(HitbtcTicker hitbtcTicker, CurrencyPair currencyPair) {
        BigDecimal bid = hitbtcTicker.getBid();
        BigDecimal ask = hitbtcTicker.getAsk();
        BigDecimal high = hitbtcTicker.getHigh();
        BigDecimal low = hitbtcTicker.getLow();
        BigDecimal last = hitbtcTicker.getLast();
        BigDecimal volume = hitbtcTicker.getVolume();
        Date timestamp = hitbtcTicker.getTimestamp();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).build();
    }

    public static List<Ticker> adaptTickers(Map<String, HitbtcTicker> hitbtcTickers) {
        ArrayList<Ticker> tickers = new ArrayList<Ticker>(hitbtcTickers.size());
        for (Map.Entry<String, HitbtcTicker> ticker : hitbtcTickers.entrySet()) {
            tickers.add(HitbtcAdapters.adaptTicker(ticker.getValue(), HitbtcAdapters.adaptSymbol(ticker.getKey())));
        }
        return tickers;
    }

    public static OrderBook adaptOrderBook(HitbtcOrderBook hitbtcOrderBook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = HitbtcAdapters.adaptMarketOrderToLimitOrder(hitbtcOrderBook.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = HitbtcAdapters.adaptMarketOrderToLimitOrder(hitbtcOrderBook.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    private static List<LimitOrder> adaptMarketOrderToLimitOrder(HitbtcOrderLimit[] hitbtcOrders, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>(hitbtcOrders.length);
        for (HitbtcOrderLimit hitbtcOrderLimit : hitbtcOrders) {
            LimitOrder limitOrder = new LimitOrder(orderType, hitbtcOrderLimit.getSize(), currencyPair, null, null, hitbtcOrderLimit.getPrice());
            orders.add(limitOrder);
        }
        return orders;
    }

    public static Order.OrderType adaptSide(HitbtcSide side) {
        switch (side) {
            case BUY: {
                return Order.OrderType.BID;
            }
            case SELL: {
                return Order.OrderType.ASK;
            }
        }
        return null;
    }

    public static Trades adaptTrades(List<? extends HitbtcTrade> allHitbtcTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>(allHitbtcTrades.size());
        long lastTradeId = 0L;
        for (int i = 0; i < allHitbtcTrades.size(); ++i) {
            long longTradeId;
            HitbtcTrade hitbtcTrade = allHitbtcTrades.get(i);
            Date timestamp = hitbtcTrade.getTimestamp();
            BigDecimal price = hitbtcTrade.getPrice();
            BigDecimal amount = hitbtcTrade.getQuantity();
            String tid = hitbtcTrade.getId();
            long l = longTradeId = tid == null ? 0L : Long.parseLong(tid);
            if (longTradeId > lastTradeId) {
                lastTradeId = longTradeId;
            }
            Order.OrderType orderType = HitbtcAdapters.adaptSide(hitbtcTrade.getSide());
            Trade trade = new Trade.Builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(timestamp).id(tid).build();
            trades.add(trade);
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByTimestamp);
    }

    public static LimitOrder adaptOrder(HitbtcOrder hitbtcOrder) {
        Order.OrderType type = HitbtcAdapters.adaptOrderType(hitbtcOrder.side);
        return new HitbtcLimitOrder(type, hitbtcOrder.quantity, HitbtcAdapters.adaptSymbol(hitbtcOrder.symbol), hitbtcOrder.id, hitbtcOrder.getCreatedAt(), hitbtcOrder.price, null, hitbtcOrder.cumQuantity, null, HitbtcAdapters.convertOrderStatus(hitbtcOrder.status), hitbtcOrder.clientOrderId);
    }

    public static List<LimitOrder> adaptOrders(List<HitbtcOrder> openOrdersRaw) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>(openOrdersRaw.size());
        for (HitbtcOrder hitbtcOrder : openOrdersRaw) {
            openOrders.add(HitbtcAdapters.adaptOrder(hitbtcOrder));
        }
        return openOrders;
    }

    public static OpenOrders adaptOpenOrders(List<HitbtcOrder> openOrdersRaw) {
        return new OpenOrders(HitbtcAdapters.adaptOrders(openOrdersRaw));
    }

    public static Order.OrderType adaptOrderType(String side) {
        return side.equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static UserTrades adaptTradeHistory(List<HitbtcOwnTrade> tradeHistoryRaw) {
        ArrayList<HitbtcUserTrade> trades = new ArrayList<HitbtcUserTrade>(tradeHistoryRaw.size());
        for (HitbtcOwnTrade hitbtcOwnTrade : tradeHistoryRaw) {
            Order.OrderType type = HitbtcAdapters.adaptOrderType(hitbtcOwnTrade.getSide().getValue());
            CurrencyPair pair = HitbtcAdapters.adaptSymbol(hitbtcOwnTrade.symbol);
            BigDecimal originalAmount = hitbtcOwnTrade.getQuantity();
            Date timestamp = hitbtcOwnTrade.getTimestamp();
            String id = Long.toString(hitbtcOwnTrade.getId());
            String orderId = String.valueOf(hitbtcOwnTrade.getOrderId());
            String clientOrderId = hitbtcOwnTrade.getClientOrderId();
            HitbtcUserTrade trade = new HitbtcUserTrade(type, originalAmount, pair, hitbtcOwnTrade.getPrice(), timestamp, id, orderId, hitbtcOwnTrade.getFee(), pair.counter, clientOrderId);
            trades.add(trade);
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static Wallet adaptWallet(String name, List<HitbtcBalance> hitbtcBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>(hitbtcBalances.size());
        for (HitbtcBalance balanceRaw : hitbtcBalances) {
            Currency currency = Currency.getInstance((String)balanceRaw.getCurrency());
            Balance balance = new Balance(currency, null, balanceRaw.getAvailable(), balanceRaw.getReserved());
            balances.add(balance);
        }
        return Wallet.Builder.from(balances).id(name).name(name).build();
    }

    public static String adaptCurrencyPair(CurrencyPair pair) {
        return pair == null ? null : pair.base.getCurrencyCode() + pair.counter.getCurrencyCode();
    }

    public static HitbtcSide getSide(Order.OrderType type) {
        return type == Order.OrderType.BID ? HitbtcSide.BUY : HitbtcSide.SELL;
    }

    public static ExchangeMetaData adaptToExchangeMetaData(List<HitbtcSymbol> symbols, Map<Currency, CurrencyMetaData> currencies, Map<CurrencyPair, CurrencyPairMetaData> currencyPairs) {
        if (symbols != null) {
            for (HitbtcSymbol symbol : symbols) {
                CurrencyPair pair = HitbtcAdapters.adaptSymbol(symbol);
                BigDecimal tickSize = symbol.getTickSize();
                int priceScale = tickSize.scale();
                BigDecimal tradingFee = symbol.getTakeLiquidityRate();
                BigDecimal minimumAmount = symbol.getQuantityIncrement();
                BigDecimal maximumAmount = null;
                FeeTier[] feeTiers = null;
                if (currencyPairs.containsKey(pair)) {
                    CurrencyPairMetaData existing = currencyPairs.get(pair);
                    minimumAmount = existing.getMinimumAmount();
                    maximumAmount = existing.getMaximumAmount();
                    feeTiers = existing.getFeeTiers();
                }
                CurrencyPairMetaData meta = new CurrencyPairMetaData(tradingFee, minimumAmount, maximumAmount, Integer.valueOf(priceScale), feeTiers);
                currencyPairs.put(pair, meta);
            }
        }
        return new ExchangeMetaData(currencyPairs, currencies, null, null, null);
    }

    public static FundingRecord adapt(HitbtcTransaction transaction) {
        String description = transaction.getType() + " " + transaction.getStatus();
        if (transaction.getIndex() != null) {
            description = description + ", index: " + transaction.getIndex();
        }
        if (transaction.getPaymentId() != null) {
            description = description + ", paymentId: " + transaction.getPaymentId();
        }
        return new FundingRecord.Builder().setAddress(transaction.getAddress()).setCurrency(Currency.getInstance((String)transaction.getCurrency())).setAmount(transaction.getAmount()).setType(HitbtcAdapters.convertType(transaction.getType())).setFee(transaction.getFee()).setDescription(description).setStatus(HitbtcAdapters.convertStatus(transaction.getStatus())).setInternalId(transaction.getId()).setBlockchainTransactionHash(transaction.getHash()).setDate(transaction.getCreatedAt()).build();
    }

    private static FundingRecord.Type convertType(String type) {
        switch (type) {
            case "payout": 
            case "withdraw": 
            case "exchangeToBank": {
                return FundingRecord.Type.WITHDRAWAL;
            }
            case "payin": 
            case "deposit": 
            case "bankToExchange": {
                return FundingRecord.Type.DEPOSIT;
            }
        }
        throw new RuntimeException("Unknown HitBTC transaction type: " + type);
    }

    private static FundingRecord.Status convertStatus(String status) {
        switch (status) {
            case "created": 
            case "pending": {
                return FundingRecord.Status.PROCESSING;
            }
            case "failed": {
                return FundingRecord.Status.FAILED;
            }
            case "success": {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown HitBTC transaction status: " + status);
    }

    private static Order.OrderStatus convertOrderStatus(String status) {
        switch (status) {
            case "new": {
                return Order.OrderStatus.NEW;
            }
            case "suspended": {
                return Order.OrderStatus.STOPPED;
            }
            case "partiallyFilled": {
                return Order.OrderStatus.PARTIALLY_FILLED;
            }
            case "filled": {
                return Order.OrderStatus.FILLED;
            }
            case "canceled": {
                return Order.OrderStatus.CANCELED;
            }
            case "expired": {
                return Order.OrderStatus.EXPIRED;
            }
        }
        throw new RuntimeException("Unknown HitBTC transaction status: " + status);
    }
}

