/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.itbit.dto.ItBitFunding;
import org.knowm.xchange.itbit.dto.account.ItBitAccountBalance;
import org.knowm.xchange.itbit.dto.account.ItBitAccountInfoReturn;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTicker;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTrade;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTrades;
import org.knowm.xchange.itbit.dto.trade.ItBitOrder;
import org.knowm.xchange.itbit.dto.trade.ItBitTradeHistory;
import org.knowm.xchange.itbit.dto.trade.ItBitUserTrade;
import org.knowm.xchange.utils.DateUtils;

public final class ItBitAdapters {
    private static final OpenOrders noOpenOrders = new OpenOrders(Collections.emptyList());
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DecimalFormatSymbols CUSTOM_SYMBOLS = new DecimalFormatSymbols();
    private static Pattern TIMESTAMP_PATTERN = Pattern.compile("(.*\\.[0-9]{3})0000Z$");

    private ItBitAdapters() {
    }

    private static DateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    private static DecimalFormat getCryptoFormat() {
        DecimalFormat cryptoFormat = new DecimalFormat();
        cryptoFormat.setDecimalFormatSymbols(CUSTOM_SYMBOLS);
        cryptoFormat.setMaximumFractionDigits(4);
        cryptoFormat.setGroupingUsed(false);
        cryptoFormat.setRoundingMode(RoundingMode.DOWN);
        return cryptoFormat;
    }

    private static DecimalFormat getFiatFormat() {
        DecimalFormat fiatFormat = new DecimalFormat();
        fiatFormat.setDecimalFormatSymbols(CUSTOM_SYMBOLS);
        fiatFormat.setMaximumFractionDigits(2);
        fiatFormat.setGroupingUsed(false);
        fiatFormat.setRoundingMode(RoundingMode.DOWN);
        return fiatFormat;
    }

    private static Date parseDate(String date) {
        Date parse;
        try {
            parse = ItBitAdapters.getDateFormat().parse(date.substring(0, 23) + 'Z');
        }
        catch (ParseException e) {
            return null;
        }
        return parse;
    }

    public static Trades adaptTrades(ItBitTrades trades, CurrencyPair currencyPair) throws InvalidFormatException {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.getCount());
        long lastMatchNumber = 0L;
        for (int i = 0; i < trades.getCount(); ++i) {
            ItBitTrade trade = trades.getTrades()[i];
            long matchNumber = trade.getMatchNumber();
            if (matchNumber > lastMatchNumber) {
                lastMatchNumber = matchNumber;
            }
            tradesList.add(ItBitAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastMatchNumber, Trades.TradeSortType.SortByID);
    }

    public static Trade adaptTrade(ItBitTrade trade, CurrencyPair currencyPair) throws InvalidFormatException {
        String timestamp = trade.getTimestamp();
        Matcher matcher = TIMESTAMP_PATTERN.matcher(timestamp);
        if (matcher.matches()) {
            timestamp = matcher.group(1) + "Z";
        }
        Date date = DateUtils.fromISODateString((String)timestamp);
        String matchNumber = String.valueOf(trade.getMatchNumber());
        return new Trade.Builder().originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(date).id(matchNumber).build();
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> orders, CurrencyPair currencyPair, Order.OrderType orderType) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        if (orders == null) {
            return limitOrders;
        }
        for (BigDecimal[] level : orders) {
            limitOrders.add(ItBitAdapters.adaptOrder(level[1], level[0], currencyPair, null, orderType, null));
        }
        return limitOrders;
    }

    private static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, CurrencyPair currencyPair, String orderId, Order.OrderType orderType, Date timestamp) {
        return new LimitOrder(orderType, amount, currencyPair, orderId, timestamp, price);
    }

    public static AccountInfo adaptAccountInfo(ItBitAccountInfoReturn[] info) {
        ArrayList<Wallet> wallets = new ArrayList<Wallet>(info.length);
        String userId = "";
        for (int i = 0; i < info.length; ++i) {
            ItBitAccountInfoReturn itBitAccountInfoReturn = info[i];
            ItBitAccountBalance[] balances = itBitAccountInfoReturn.getBalances();
            userId = itBitAccountInfoReturn.getUserId();
            ArrayList<Balance> walletContent = new ArrayList<Balance>(balances.length);
            for (int j = 0; j < balances.length; ++j) {
                ItBitAccountBalance itBitAccountBalance = balances[j];
                Currency currency = ItBitAdapters.adaptCcy(itBitAccountBalance.getCurrency());
                Balance balance = new Balance(currency, itBitAccountBalance.getTotalBalance(), itBitAccountBalance.getAvailableBalance());
                walletContent.add(balance);
            }
            wallets.add(Wallet.Builder.from(walletContent).id(itBitAccountInfoReturn.getId()).name(itBitAccountInfoReturn.getName()).build());
        }
        return new AccountInfo(userId, wallets);
    }

    public static OpenOrders adaptPrivateOrders(ItBitOrder[] orders) {
        if (orders.length <= 0) {
            return noOpenOrders;
        }
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(orders.length);
        for (int i = 0; i < orders.length; ++i) {
            ItBitOrder itBitOrder = orders[i];
            String instrument = itBitOrder.getInstrument();
            CurrencyPair currencyPair = new CurrencyPair(instrument.substring(0, 3), instrument.substring(3, 6));
            Order.OrderType orderType = itBitOrder.getSide().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
            Date timestamp = ItBitAdapters.parseDate(itBitOrder.getCreatedTime());
            limitOrders.add(ItBitAdapters.adaptOrder(itBitOrder.getAmount(), itBitOrder.getPrice(), currencyPair, itBitOrder.getId(), orderType, timestamp));
        }
        return new OpenOrders(limitOrders);
    }

    public static UserTrades adaptTradeHistory(ItBitTradeHistory history) {
        List<ItBitUserTrade> itBitTrades = history.getTradingHistory();
        ArrayListMultimap tradesByOrderId = ArrayListMultimap.create();
        for (ItBitUserTrade itBitTrade : itBitTrades) {
            tradesByOrderId.put((Object)itBitTrade.getOrderId(), (Object)itBitTrade);
        }
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (String orderId : tradesByOrderId.keySet()) {
            BigDecimal totalValue = BigDecimal.ZERO;
            BigDecimal totalQuantity = BigDecimal.ZERO;
            BigDecimal totalFee = BigDecimal.ZERO;
            for (ItBitUserTrade trade : tradesByOrderId.get((Object)orderId)) {
                totalValue = totalValue.add(trade.getCurrency1Amount().multiply(trade.getRate()));
                totalQuantity = totalQuantity.add(trade.getCurrency1Amount());
                totalFee = totalFee.add(trade.getCommissionPaid());
                totalFee = totalFee.subtract(trade.getRebatesApplied());
            }
            BigDecimal volumeWeightedAveragePrice = totalValue.divide(totalQuantity, 8, 4);
            ItBitUserTrade itBitTrade = (ItBitUserTrade)tradesByOrderId.get((Object)orderId).get(0);
            Order.OrderType orderType = itBitTrade.getDirection().equals((Object)ItBitUserTrade.Direction.buy) ? Order.OrderType.BID : Order.OrderType.ASK;
            CurrencyPair currencyPair = ItBitAdapters.adaptCcyPair(itBitTrade.getInstrument());
            String ccy = itBitTrade.getCommissionCurrency();
            Currency feeCcy = ItBitAdapters.adaptCcy(ccy == null ? itBitTrade.getRebateCurrency() : ccy);
            UserTrade userTrade = new UserTrade.Builder().type(orderType).originalAmount(totalQuantity).currencyPair(currencyPair).price(volumeWeightedAveragePrice).timestamp(itBitTrade.getTimestamp()).id(orderId).orderId(orderId).feeAmount(totalFee).feeCurrency(feeCcy).build();
            trades.add(userTrade);
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static CurrencyPair adaptCcyPair(String instrument) {
        Currency base = ItBitAdapters.adaptCcy(instrument.substring(0, 3));
        Currency counter = ItBitAdapters.adaptCcy(instrument.substring(3, 6));
        return new CurrencyPair(base, counter);
    }

    public static Currency adaptCcy(String ccy) {
        if (ccy.toUpperCase().equals("XBT")) {
            return Currency.BTC;
        }
        return Currency.getInstance((String)ccy);
    }

    public static Ticker adaptTicker(CurrencyPair currencyPair, ItBitTicker itBitTicker) {
        BigDecimal bid = itBitTicker.getBid();
        BigDecimal ask = itBitTicker.getAsk();
        BigDecimal high = itBitTicker.getHighToday();
        BigDecimal low = itBitTicker.getLowToday();
        BigDecimal last = itBitTicker.getLastPrice();
        BigDecimal volume = itBitTicker.getVolume24h();
        Date timestamp = itBitTicker.getTimestamp() != null ? ItBitAdapters.parseDate(itBitTicker.getTimestamp()) : null;
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(timestamp).bidSize(itBitTicker.getBidAmt()).askSize(itBitTicker.getAskAmt()).build();
    }

    public static String formatFiatAmount(BigDecimal amount) {
        return ItBitAdapters.getFiatFormat().format(amount.add(new BigDecimal(1.0E-8)));
    }

    public static String formatCryptoAmount(BigDecimal amount) {
        return ItBitAdapters.getCryptoFormat().format(amount.add(new BigDecimal(1.0E-8)));
    }

    public static CurrencyPair adaptCurrencyPairToExchange(CurrencyPair currencyPair) {
        return new CurrencyPair(ItBitAdapters.adaptCurrencyToExchange(currencyPair.base), ItBitAdapters.adaptCurrencyToExchange(currencyPair.counter));
    }

    public static Currency adaptCurrencyToExchange(Currency currency) {
        if (currency == Currency.BTC) {
            return currency.getIso4217Currency();
        }
        return currency;
    }

    public static FundingRecord adapt(ItBitFunding itBitFunding) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        try {
            Date date = dateFormat.parse(itBitFunding.time);
            FundingRecord.Type type = itBitFunding.transactionType.equalsIgnoreCase("Deposit") ? FundingRecord.Type.DEPOSIT : FundingRecord.Type.WITHDRAWAL;
            FundingRecord.Status status = FundingRecord.Status.PROCESSING;
            if (itBitFunding.status.equals("cancelled")) {
                status = FundingRecord.Status.CANCELLED;
            }
            if (itBitFunding.status.equals("completed")) {
                status = FundingRecord.Status.COMPLETE;
            }
            Currency currency = ItBitAdapters.adaptCcy(itBitFunding.currency);
            return new FundingRecord(itBitFunding.destinationAddress, date, currency, itBitFunding.amount, itBitFunding.withdrawalId, itBitFunding.txnHash, type, status, null, null, null);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Cannot parse " + itBitFunding, e);
        }
    }

    static {
        CUSTOM_SYMBOLS.setDecimalSeparator('.');
    }
}

