/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.itbit.ItBitAdapters;
import org.knowm.xchange.itbit.dto.trade.ItBitOrder;
import org.knowm.xchange.itbit.dto.trade.ItBitTradeHistory;
import org.knowm.xchange.itbit.service.ItBitOpenOrdersParams;
import org.knowm.xchange.itbit.service.ItBitTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamTransactionId;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class ItBitTradeService
extends ItBitTradeServiceRaw
implements TradeService {
    public ItBitTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders((OpenOrdersParams)this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        CurrencyPair currencyPair = null;
        if (params instanceof OpenOrdersParamCurrencyPair) {
            currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
        }
        if (currencyPair == null) {
            ArrayList<ItBitOrder> orders = new ArrayList<ItBitOrder>();
            for (CurrencyPair tmpCurrencyPair : this.exchange.getExchangeMetaData().getCurrencyPairs().keySet()) {
                orders.addAll(Arrays.asList(this.getItBitOpenOrders(tmpCurrencyPair)));
            }
            ItBitOrder[] empty = new ItBitOrder[]{};
            return ItBitAdapters.adaptPrivateOrders(orders.isEmpty() ? empty : (ItBitOrder[])Arrays.copyOf(orders.toArray(), orders.size(), ItBitOrder[].class));
        }
        ItBitOrder[] itBitOpenOrders = this.getItBitOpenOrders(currencyPair);
        return ItBitAdapters.adaptPrivateOrders(itBitOpenOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeItBitLimitOrder(limitOrder).getId();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        this.cancelItBitOrder(orderId);
        return true;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Integer page = 0;
        Integer pageLength = 50;
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging paramPaging = (TradeHistoryParamPaging)params;
            page = paramPaging.getPageNumber();
            pageLength = paramPaging.getPageLength();
        }
        String transactionId = null;
        if (params instanceof TradeHistoryParamTransactionId) {
            transactionId = ((TradeHistoryParamTransactionId)params).getTransactionId();
        }
        Date startTime = null;
        Date endTime = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan tradeHistoryParamsTimeSpan = (TradeHistoryParamsTimeSpan)params;
            startTime = tradeHistoryParamsTimeSpan.getStartTime();
            endTime = tradeHistoryParamsTimeSpan.getEndTime();
        }
        ItBitTradeHistory userTradeHistory = this.getUserTradeHistory(transactionId, page, pageLength, startTime, endTime);
        return ItBitAdapters.adaptTradeHistory(userTradeHistory);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new ItBitTradeHistoryParams(50, 0, null, null, null);
    }

    public ItBitOpenOrdersParams createOpenOrdersParams() {
        return new ItBitOpenOrdersParams();
    }

    public static class ItBitTradeHistoryParams
    extends DefaultTradeHistoryParamPaging
    implements TradeHistoryParamsTimeSpan,
    TradeHistoryParamTransactionId,
    TradeHistoryParamPaging {
        private String txId;
        private Date startTime;
        private Date endTime;

        public ItBitTradeHistoryParams(Integer pageLength, Integer pageNumber, String txId, Date startTime, Date endTime) {
            super(pageLength, pageNumber);
            this.txId = txId;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public String getTransactionId() {
            return this.txId;
        }

        public void setTransactionId(String txId) {
            this.txId = txId;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }
    }
}

