/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicTrade;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderType;
import org.knowm.xchange.kraken.dto.trade.KrakenType;

@JsonDeserialize(using=KrakenTradesDeserializer.class)
public class KrakenPublicTrades {
    private final List<KrakenPublicTrade> trades;
    private final long last;

    public KrakenPublicTrades(List<KrakenPublicTrade> trades, long last) {
        this.trades = trades;
        this.last = last;
    }

    public long getLast() {
        return this.last;
    }

    public List<KrakenPublicTrade> getTrades() {
        return this.trades;
    }

    public String toString() {
        return "KrakenTrades [trades=" + this.trades + ", last=" + this.last + "]";
    }

    static class KrakenTradesDeserializer
    extends JsonDeserializer<KrakenPublicTrades> {
        KrakenTradesDeserializer() {
        }

        public KrakenPublicTrades deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<KrakenPublicTrade> krakenTrades = new ArrayList<KrakenPublicTrade>();
            long last = 0L;
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator tradesResultIterator = node.fields();
            while (tradesResultIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)tradesResultIterator.next();
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (key == "last") {
                    last = value.asLong();
                    continue;
                }
                if (!value.isArray()) continue;
                for (JsonNode tradeJsonNode : value) {
                    BigDecimal price = new BigDecimal(tradeJsonNode.path(0).asText());
                    BigDecimal volume = new BigDecimal(tradeJsonNode.path(1).asText());
                    double time = tradeJsonNode.path(2).asDouble();
                    KrakenType type = KrakenType.fromString(tradeJsonNode.path(3).asText());
                    KrakenOrderType orderType = KrakenOrderType.fromString(tradeJsonNode.path(4).asText());
                    String miscellaneous = tradeJsonNode.path(5).asText();
                    krakenTrades.add(new KrakenPublicTrade(price, volume, time, type, orderType, miscellaneous));
                }
            }
            return new KrakenPublicTrades(krakenTrades, last);
        }
    }
}

