/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.kraken.KrakenAdapters;
import org.knowm.xchange.kraken.dto.account.KrakenDepositAddress;
import org.knowm.xchange.kraken.dto.account.KrakenLedger;
import org.knowm.xchange.kraken.dto.account.KrakenTradeBalanceInfo;
import org.knowm.xchange.kraken.dto.account.LedgerType;
import org.knowm.xchange.kraken.service.KrakenAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencies;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class KrakenAccountService
extends KrakenAccountServiceRaw
implements AccountService {
    public KrakenAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        KrakenTradeBalanceInfo krakenTradeBalanceInfo = this.getKrakenTradeBalance();
        Wallet tradingWallet = KrakenAdapters.adaptWallet(this.getKrakenBalance());
        Wallet marginWallet = Wallet.Builder.from(tradingWallet.getBalances().values()).id("margin").features(EnumSet.of(Wallet.WalletFeature.FUNDING, Wallet.WalletFeature.MARGIN_TRADING)).maxLeverage(BigDecimal.valueOf(5L)).currentLeverage(krakenTradeBalanceInfo.getTradeBalance().equals(BigDecimal.ZERO) ? BigDecimal.ZERO : krakenTradeBalanceInfo.getCostBasis().divide(krakenTradeBalanceInfo.getTradeBalance(), MathContext.DECIMAL32)).build();
        return new AccountInfo(this.exchange.getExchangeSpecification().getUserName(), new Wallet[]{tradingWallet, marginWallet});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdraw(null, currency.toString(), address, amount).getRefid();
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        KrakenDepositAddress[] depositAddresses;
        if (Currency.BTC.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Bitcoin");
        } else if (Currency.LTC.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Litecoin");
        } else if (Currency.ETH.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Ether (Hex)");
        } else if (Currency.ZEC.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Zcash (Transparent)");
        } else if (Currency.ADA.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "ADA");
        } else if (Currency.XMR.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Monero");
        } else if (Currency.XRP.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Ripple XRP");
        } else if (Currency.XLM.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Stellar XLM");
        } else if (Currency.BCH.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Bitcoin Cash");
        } else if (Currency.REP.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "REP");
        } else if (Currency.USD.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "SynapsePay (US Wire)");
        } else if (Currency.XDG.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Dogecoin");
        } else if (Currency.MLN.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "MLN");
        } else if (Currency.GNO.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "GNO");
        } else if (Currency.QTUM.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "QTUM");
        } else if (Currency.XTZ.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "XTZ");
        } else if (Currency.ATOM.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Cosmos");
        } else if (Currency.EOS.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "EOS");
        } else if (Currency.DASH.equals((Object)currency)) {
            depositAddresses = this.getDepositAddresses(currency.toString(), "Dash");
        } else {
            throw new RuntimeException("Not implemented yet, Kraken works only for BTC and LTC");
        }
        return KrakenAdapters.adaptKrakenDepositAddress(depositAddresses);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new KrakenFundingHistoryParams(null, null, null, null);
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        TradeHistoryParamCurrencies currenciesParam;
        Date startTime = null;
        Date endTime = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan timeSpanParam = (TradeHistoryParamsTimeSpan)params;
            startTime = timeSpanParam.getStartTime();
            endTime = timeSpanParam.getEndTime();
        }
        Long offset = null;
        if (params instanceof TradeHistoryParamOffset) {
            offset = ((TradeHistoryParamOffset)params).getOffset();
        }
        Currency[] currencies = null;
        if (params instanceof TradeHistoryParamCurrencies && (currenciesParam = (TradeHistoryParamCurrencies)params).getCurrencies() != null) {
            currencies = currenciesParam.getCurrencies();
        }
        LedgerType ledgerType = null;
        if (params instanceof HistoryParamsFundingType) {
            FundingRecord.Type type = ((HistoryParamsFundingType)params).getType();
            LedgerType ledgerType2 = type == FundingRecord.Type.DEPOSIT ? LedgerType.DEPOSIT : (ledgerType = type == FundingRecord.Type.WITHDRAWAL ? LedgerType.WITHDRAWAL : null);
        }
        if (ledgerType == null) {
            Map<String, KrakenLedger> ledgerEntries = this.getKrakenLedgerInfo(LedgerType.DEPOSIT, startTime, endTime, offset, currencies);
            ledgerEntries.putAll(this.getKrakenLedgerInfo(LedgerType.WITHDRAWAL, startTime, endTime, offset, currencies));
            return KrakenAdapters.adaptFundingHistory(ledgerEntries);
        }
        return KrakenAdapters.adaptFundingHistory(this.getKrakenLedgerInfo(ledgerType, startTime, endTime, offset, currencies));
    }

    public static class KrakenFundingHistoryParams
    extends DefaultTradeHistoryParamsTimeSpan
    implements TradeHistoryParamOffset,
    TradeHistoryParamCurrencies,
    HistoryParamsFundingType {
        private Long offset;
        private Currency[] currencies;
        private FundingRecord.Type type;

        public KrakenFundingHistoryParams(Date startTime, Date endTime, Long offset, Currency ... currencies) {
            super(startTime, endTime);
            this.offset = offset;
            this.currencies = currencies;
        }

        public Long getOffset() {
            return this.offset;
        }

        public void setOffset(Long offset) {
            this.offset = offset;
        }

        public Currency[] getCurrencies() {
            return this.currencies;
        }

        public void setCurrencies(Currency[] currencies) {
            this.currencies = currencies;
        }

        public FundingRecord.Type getType() {
            return this.type;
        }

        public void setType(FundingRecord.Type type) {
            this.type = type;
        }
    }
}

