/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kraken.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.kraken.KrakenUtils;
import org.knowm.xchange.kraken.dto.account.DepostitStatus;
import org.knowm.xchange.kraken.dto.account.KrakenDepositAddress;
import org.knowm.xchange.kraken.dto.account.KrakenDepositMethods;
import org.knowm.xchange.kraken.dto.account.KrakenLedger;
import org.knowm.xchange.kraken.dto.account.KrakenTradeBalanceInfo;
import org.knowm.xchange.kraken.dto.account.KrakenTradeVolume;
import org.knowm.xchange.kraken.dto.account.KrakenWebsocketToken;
import org.knowm.xchange.kraken.dto.account.LedgerType;
import org.knowm.xchange.kraken.dto.account.Withdraw;
import org.knowm.xchange.kraken.dto.account.WithdrawInfo;
import org.knowm.xchange.kraken.dto.account.WithdrawStatus;
import org.knowm.xchange.kraken.dto.account.results.DepositStatusResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenBalanceResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenDepositAddressResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenDepositMethodsResults;
import org.knowm.xchange.kraken.dto.account.results.KrakenLedgerResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenQueryLedgerResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenTradeBalanceInfoResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenTradeVolumeResult;
import org.knowm.xchange.kraken.dto.account.results.KrakenWebsocketTokenResult;
import org.knowm.xchange.kraken.dto.account.results.WithdrawInfoResult;
import org.knowm.xchange.kraken.dto.account.results.WithdrawResult;
import org.knowm.xchange.kraken.dto.account.results.WithdrawStatusResult;
import org.knowm.xchange.kraken.service.KrakenBaseService;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class KrakenAccountServiceRaw
extends KrakenBaseService {
    public KrakenAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, BigDecimal> getKrakenBalance() throws IOException {
        KrakenBalanceResult balanceResult = this.kraken.balance(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(balanceResult);
    }

    public KrakenDepositAddress[] getDepositAddresses(String currency, String method) throws IOException {
        KrakenDepositAddressResult depositAddressesResult = this.kraken.getDepositAddresses(null, currency, method, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(depositAddressesResult);
    }

    public KrakenDepositMethods[] getDepositMethods(String assetPairs, String assets) throws IOException {
        KrakenDepositMethodsResults depositMethods = this.kraken.getDepositMethods(assetPairs, assets, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(depositMethods);
    }

    public WithdrawInfo getWithdrawInfo(String assetPairs, String assets, String key, BigDecimal amount) throws IOException {
        WithdrawInfoResult withdrawInfoResult = this.kraken.getWithdrawInfo(assetPairs, assets, key, amount, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(withdrawInfoResult);
    }

    public Withdraw withdraw(String assetPairs, String assets, String key, BigDecimal amount) throws IOException {
        WithdrawResult withdrawResult = this.kraken.withdraw(assetPairs, assets, key, amount, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(withdrawResult);
    }

    public List<DepostitStatus> getDepositStatus(String assetPairs, String assets, String method) throws IOException {
        DepositStatusResult result = this.kraken.getDepositStatus(assetPairs, assets, method, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }

    public List<WithdrawStatus> getWithdrawStatus(String assetPairs, String assets, String method) throws IOException {
        WithdrawStatusResult result = this.kraken.getWithdrawStatus(assetPairs, assets, method, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }

    public KrakenTradeBalanceInfo getKrakenTradeBalance(Currency valuationCurrency) throws IOException {
        String valuationCurrencyCode = null;
        if (valuationCurrency != null) {
            valuationCurrencyCode = KrakenUtils.getKrakenCurrencyCode(valuationCurrency);
        }
        KrakenTradeBalanceInfoResult balanceResult = this.kraken.tradeBalance(null, valuationCurrencyCode, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(balanceResult);
    }

    public KrakenTradeBalanceInfo getKrakenTradeBalance() throws IOException {
        return this.getKrakenTradeBalance(null);
    }

    public Map<String, KrakenLedger> getKrakenLedgerInfo() throws IOException {
        return this.getKrakenLedgerInfo(null, null, null, null, new Currency[0]);
    }

    public Map<String, KrakenLedger> getKrakenPartialLedgerInfo(LedgerType ledgerType, String startTime, String endTime, Long offset, Currency ... assets) throws IOException {
        String ledgerTypeString = ledgerType == null ? "all" : ledgerType.toString().toLowerCase();
        KrakenLedgerResult ledgerResult = this.kraken.ledgers(null, this.delimitAssets(assets), ledgerTypeString, startTime, endTime, offset, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(ledgerResult).getLedgerMap();
    }

    public Map<String, KrakenLedger> getKrakenLedgerInfo(LedgerType ledgerType, Date start, Date end, Long offset, Currency ... assets) throws IOException {
        Map<String, KrakenLedger> fullLedgerMap;
        String startTime = null;
        String endTime = null;
        long longOffset = 0L;
        if (start != null) {
            startTime = String.valueOf(DateUtils.toUnixTime((Date)start));
        }
        if (end != null) {
            endTime = String.valueOf(DateUtils.toUnixTime((Date)end));
        }
        if (offset != null) {
            longOffset = offset;
        }
        Map<String, KrakenLedger> lastLedgerMap = fullLedgerMap = this.getKrakenPartialLedgerInfo(ledgerType, startTime, endTime, offset, assets);
        while (!(lastLedgerMap.isEmpty() || (lastLedgerMap = this.getKrakenPartialLedgerInfo(ledgerType, startTime, endTime, longOffset += (long)lastLedgerMap.size(), assets)).size() == 1 && fullLedgerMap.keySet().containsAll(lastLedgerMap.keySet()))) {
            fullLedgerMap.putAll(lastLedgerMap);
        }
        return fullLedgerMap;
    }

    public KrakenWebsocketToken getKrakenWebsocketToken() throws IOException {
        KrakenWebsocketTokenResult tokenResult = this.kraken.getWebsocketToken(null, null, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(tokenResult);
    }

    public Map<String, KrakenLedger> queryKrakenLedger(String ... ledgerIds) throws IOException {
        KrakenQueryLedgerResult ledgerResult = this.kraken.queryLedgers(this.createDelimitedString(ledgerIds), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(ledgerResult);
    }

    public KrakenTradeVolume getTradeVolume(CurrencyPair ... currencyPairs) throws IOException {
        KrakenTradeVolumeResult result = this.kraken.tradeVolume(this.delimitAssetPairs(currencyPairs), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.checkResult(result);
    }
}

