/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.kucoin.KucoinBaseService;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.dto.request.ApplyWithdrawApiRequest;
import org.knowm.xchange.kucoin.dto.request.CreateAccountRequest;
import org.knowm.xchange.kucoin.dto.request.InnerTransferRequest;
import org.knowm.xchange.kucoin.dto.response.AccountBalancesResponse;
import org.knowm.xchange.kucoin.dto.response.AccountLedgersResponse;
import org.knowm.xchange.kucoin.dto.response.ApplyWithdrawResponse;
import org.knowm.xchange.kucoin.dto.response.DepositAddressResponse;
import org.knowm.xchange.kucoin.dto.response.DepositResponse;
import org.knowm.xchange.kucoin.dto.response.InternalTransferResponse;
import org.knowm.xchange.kucoin.dto.response.KucoinResponse;
import org.knowm.xchange.kucoin.dto.response.Pagination;
import org.knowm.xchange.kucoin.dto.response.WithdrawalResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinAccountServiceRaw
extends KucoinBaseService {
    protected KucoinAccountServiceRaw(KucoinExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public List<AccountBalancesResponse> getKucoinAccounts() throws IOException {
        this.checkAuthenticated();
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.accountApi.getAccountList(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, null, null)).withRetry(this.retry("accountList")).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public Void createKucoinAccount(String currency, String type) throws IOException {
        this.checkAuthenticated();
        return (Void)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.accountApi.createAccount(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, CreateAccountRequest.builder().currency(currency).type(type).build())).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public ApplyWithdrawResponse applyWithdraw(ApplyWithdrawApiRequest req) throws IOException {
        this.checkAuthenticated();
        return (ApplyWithdrawResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.withdrawalAPI.applyWithdraw(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, req)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public InternalTransferResponse innerTransfer(InnerTransferRequest req) throws IOException {
        this.checkAuthenticated();
        return (InternalTransferResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.accountApi.innerTransfer(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, req)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    @Deprecated
    public Pagination<AccountLedgersResponse> getAccountLedgers(String accountId, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.accountApi.getAccountLedgers(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, accountId, startAt, endAt, pageSize, currentPage)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public Pagination<AccountLedgersResponse> getAccountLedgersWithParams(String currency, String direction, String bizType, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.accountApi.getAccountLedgersWithParams(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, direction, bizType, startAt, endAt, pageSize, currentPage)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public Pagination<WithdrawalResponse> getWithdrawalsList(String currency, String status, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.withdrawalAPI.getWithdrawalsList(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, status, startAt, endAt, pageSize, currentPage)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public Pagination<DepositResponse> getDepositList(String currency, String status, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.depositAPI.getDepositList(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, status, startAt, endAt, pageSize, currentPage)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public DepositAddressResponse createDepositAddress(String currency, String chain) throws IOException {
        this.checkAuthenticated();
        return (DepositAddressResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.depositAPI.createDepositAddress(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, chain)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public DepositAddressResponse getDepositAddress(String currency, String chain) throws IOException {
        this.checkAuthenticated();
        return (DepositAddressResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.depositAPI.getDepositAddress(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, chain)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public List<DepositAddressResponse> getDepositAddresses(String currency) throws IOException {
        this.checkAuthenticated();
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.depositAPI.getDepositAddresses(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }
}

