/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.kucoin.KucoinBaseService;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.dto.request.OrderCreateApiRequest;
import org.knowm.xchange.kucoin.dto.response.HistOrdersResponse;
import org.knowm.xchange.kucoin.dto.response.OrderCancelResponse;
import org.knowm.xchange.kucoin.dto.response.OrderCreateResponse;
import org.knowm.xchange.kucoin.dto.response.OrderResponse;
import org.knowm.xchange.kucoin.dto.response.Pagination;
import org.knowm.xchange.kucoin.dto.response.TradeResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinTradeServiceRaw
extends KucoinBaseService {
    protected KucoinTradeServiceRaw(KucoinExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public Pagination<OrderResponse> getKucoinOpenOrders(String symbol, int page, int pageSize) throws IOException {
        return this.getKucoinOrders(symbol, "active", page, pageSize);
    }

    public Pagination<OrderResponse> getKucoinClosedOrders(String symbol, int page, int pageSize) throws IOException {
        return this.getKucoinOrders(symbol, "done", page, pageSize);
    }

    public Pagination<OrderResponse> getKucoinOrders(String symbol, String status, int page, int pageSize) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.queryOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol, null, null, status, null, null, pageSize, page));
    }

    public OrderResponse getKucoinOrder(String id) throws IOException {
        this.checkAuthenticated();
        return (OrderResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.getOrder(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, id));
    }

    public Pagination<TradeResponse> getKucoinFills(String symbol, String orderId, int page, int pageSize, Long startAt, Long endAt) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.fillApi.queryTrades(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol, orderId, null, null, startAt, endAt, pageSize, page));
    }

    public Pagination<HistOrdersResponse> getKucoinHistOrders(String symbol, int page, int pageSize, Long startAt, Long endAt) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.histOrdersApi.queryHistOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol, null, startAt, endAt, pageSize, page));
    }

    public OrderCancelResponse kucoinCancelAllOrders(String symbol) throws IOException {
        this.checkAuthenticated();
        return (OrderCancelResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.cancelOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol));
    }

    public OrderCancelResponse kucoinCancelOrder(String orderId) throws IOException {
        this.checkAuthenticated();
        return (OrderCancelResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.cancelOrder(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, orderId));
    }

    public OrderCreateResponse kucoinCreateOrder(OrderCreateApiRequest opsRequest) throws IOException {
        this.checkAuthenticated();
        return (OrderCreateResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.createOrder(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, opsRequest));
    }

    public List<OrderResponse> getKucoinRecentOrders() throws IOException {
        this.checkAuthenticated();
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> this.limitOrderAPI.getRecentOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase));
    }
}

