/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin.dto.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_NULL)
public class InnerTransferRequest {
    private final String clientOid;
    private final String currency;
    private final String from;
    private final String to;
    private final BigDecimal amount;

    InnerTransferRequest(String clientOid, String currency, String from, String to, BigDecimal amount) {
        this.clientOid = clientOid;
        this.currency = currency;
        this.from = from;
        this.to = to;
        this.amount = amount;
    }

    public static InnerTransferRequestBuilder builder() {
        return new InnerTransferRequestBuilder();
    }

    public String getClientOid() {
        return this.clientOid;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String toString() {
        return "InnerTransferRequest(clientOid=" + this.getClientOid() + ", currency=" + this.getCurrency() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", amount=" + this.getAmount() + ")";
    }

    public static class InnerTransferRequestBuilder {
        private String clientOid;
        private String currency;
        private String from;
        private String to;
        private BigDecimal amount;

        InnerTransferRequestBuilder() {
        }

        public InnerTransferRequestBuilder clientOid(String clientOid) {
            this.clientOid = clientOid;
            return this;
        }

        public InnerTransferRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public InnerTransferRequestBuilder from(String from) {
            this.from = from;
            return this;
        }

        public InnerTransferRequestBuilder to(String to) {
            this.to = to;
            return this;
        }

        public InnerTransferRequestBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public InnerTransferRequest build() {
            return new InnerTransferRequest(this.clientOid, this.currency, this.from, this.to, this.amount);
        }

        public String toString() {
            return "InnerTransferRequest.InnerTransferRequestBuilder(clientOid=" + this.clientOid + ", currency=" + this.currency + ", from=" + this.from + ", to=" + this.to + ", amount=" + this.amount + ")";
        }
    }
}

