/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin.dto.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.kucoin.dto.KlineIntervalType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KucoinKline {
    private final CurrencyPair pair;
    private final KlineIntervalType intervalType;
    private final Long time;
    private final BigDecimal open;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal close;
    private final BigDecimal volume;
    private final BigDecimal amount;

    public KucoinKline(CurrencyPair pair, KlineIntervalType intervalType, Object[] obj) {
        this.pair = pair;
        this.intervalType = intervalType;
        this.time = Long.valueOf(obj[0].toString());
        this.open = new BigDecimal(obj[1].toString());
        this.close = new BigDecimal(obj[2].toString());
        this.high = new BigDecimal(obj[3].toString());
        this.low = new BigDecimal(obj[4].toString());
        this.volume = new BigDecimal(obj[5].toString());
        this.amount = new BigDecimal(obj[6].toString());
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    public KlineIntervalType getIntervalType() {
        return this.intervalType;
    }

    public Long getTime() {
        return this.time;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getClose() {
        return this.close;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KucoinKline)) {
            return false;
        }
        KucoinKline other = (KucoinKline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        CurrencyPair this$pair = this.getPair();
        CurrencyPair other$pair = other.getPair();
        if (this$pair == null ? other$pair != null : !this$pair.equals(other$pair)) {
            return false;
        }
        KlineIntervalType this$intervalType = this.getIntervalType();
        KlineIntervalType other$intervalType = other.getIntervalType();
        if (this$intervalType == null ? other$intervalType != null : !((Object)((Object)this$intervalType)).equals((Object)other$intervalType)) {
            return false;
        }
        BigDecimal this$open = this.getOpen();
        BigDecimal other$open = other.getOpen();
        if (this$open == null ? other$open != null : !((Object)this$open).equals(other$open)) {
            return false;
        }
        BigDecimal this$high = this.getHigh();
        BigDecimal other$high = other.getHigh();
        if (this$high == null ? other$high != null : !((Object)this$high).equals(other$high)) {
            return false;
        }
        BigDecimal this$low = this.getLow();
        BigDecimal other$low = other.getLow();
        if (this$low == null ? other$low != null : !((Object)this$low).equals(other$low)) {
            return false;
        }
        BigDecimal this$close = this.getClose();
        BigDecimal other$close = other.getClose();
        if (this$close == null ? other$close != null : !((Object)this$close).equals(other$close)) {
            return false;
        }
        BigDecimal this$volume = this.getVolume();
        BigDecimal other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KucoinKline;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        CurrencyPair $pair = this.getPair();
        result = result * 59 + ($pair == null ? 43 : $pair.hashCode());
        KlineIntervalType $intervalType = this.getIntervalType();
        result = result * 59 + ($intervalType == null ? 43 : ((Object)((Object)$intervalType)).hashCode());
        BigDecimal $open = this.getOpen();
        result = result * 59 + ($open == null ? 43 : ((Object)$open).hashCode());
        BigDecimal $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : ((Object)$high).hashCode());
        BigDecimal $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : ((Object)$low).hashCode());
        BigDecimal $close = this.getClose();
        result = result * 59 + ($close == null ? 43 : ((Object)$close).hashCode());
        BigDecimal $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    public String toString() {
        return "KucoinKline(pair=" + this.getPair() + ", intervalType=" + (Object)((Object)this.getIntervalType()) + ", time=" + this.getTime() + ", open=" + this.getOpen() + ", high=" + this.getHigh() + ", low=" + this.getLow() + ", close=" + this.getClose() + ", volume=" + this.getVolume() + ", amount=" + this.getAmount() + ")";
    }
}

