/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.kucoin.dto.response.AllTickersResponse;
import org.knowm.xchange.kucoin.dto.response.CurrenciesResponse;
import org.knowm.xchange.kucoin.dto.response.KucoinResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolTickResponse;
import org.knowm.xchange.kucoin.dto.response.TickerResponse;

@Path(value="api/v1")
@Produces(value={"application/json"})
public interface SymbolAPI {
    @GET
    @Path(value="/symbols")
    public KucoinResponse<List<SymbolResponse>> getSymbols() throws IOException;

    @GET
    @Path(value="/currencies")
    public KucoinResponse<List<CurrenciesResponse>> getCurrencies() throws IOException;

    @GET
    @Path(value="/prices")
    public KucoinResponse<Map<String, BigDecimal>> getPrices() throws IOException;

    @GET
    @Path(value="/market/orderbook/level1")
    public KucoinResponse<TickerResponse> getTicker(@QueryParam(value="symbol") String var1) throws IOException;

    @GET
    @Path(value="/market/allTickers")
    public KucoinResponse<AllTickersResponse> getTickers() throws IOException;

    @GET
    @Path(value="/market/stats")
    public KucoinResponse<SymbolTickResponse> getMarketStats(@QueryParam(value="symbol") String var1) throws IOException;
}

