/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.kucoin.KucoinAccountServiceRaw;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.KucoinTradeHistoryParams;
import org.knowm.xchange.kucoin.dto.response.AccountBalancesResponse;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;

public class KucoinAccountService
extends KucoinAccountServiceRaw
implements AccountService {
    KucoinAccountService(KucoinExchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        List<AccountBalancesResponse> accounts = this.getKucoinAccounts();
        return new AccountInfo((Collection)accounts.stream().map(AccountBalancesResponse::getType).distinct().map(type -> Wallet.Builder.from((Collection)accounts.stream().filter(a -> a.getType().equals(type)).map(KucoinAdapters::adaptBalance).collect(Collectors.toList())).id(type).build()).collect(Collectors.toList()));
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new KucoinTradeHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        String currency = null;
        if (params instanceof TradeHistoryParamCurrency) {
            Currency c = ((TradeHistoryParamCurrency)params).getCurrency();
            currency = c == null ? null : c.getCurrencyCode();
        }
        boolean withdrawals = true;
        boolean deposits = true;
        if (params instanceof HistoryParamsFundingType) {
            HistoryParamsFundingType p = (HistoryParamsFundingType)params;
            withdrawals = p.getType() == null || p.getType() == FundingRecord.Type.WITHDRAWAL;
            deposits = p.getType() == null || p.getType() == FundingRecord.Type.DEPOSIT;
        }
        Long startAt = null;
        Long endAt = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan p = (TradeHistoryParamsTimeSpan)params;
            startAt = p.getStartTime() == null ? null : Long.valueOf(p.getStartTime().getTime());
            endAt = p.getEndTime() == null ? null : Long.valueOf(p.getEndTime().getTime());
        }
        ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
        if (withdrawals) {
            result.addAll(this.getWithdrawalsList(currency, null, startAt, endAt, null, null).getItems().stream().map(KucoinAdapters::adaptFundingRecord).collect(Collectors.toList()));
        }
        if (deposits) {
            result.addAll(this.getDepositList(currency, null, startAt, endAt, null, null).getItems().stream().map(KucoinAdapters::adaptFundingRecord).collect(Collectors.toList()));
        }
        return result;
    }
}

