/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinBaseService;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.dto.response.AllTickersResponse;
import org.knowm.xchange.kucoin.dto.response.OrderBookResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolTickResponse;
import org.knowm.xchange.kucoin.dto.response.TickerResponse;
import org.knowm.xchange.kucoin.dto.response.TradeHistoryResponse;

public class KucoinMarketDataServiceRaw
extends KucoinBaseService {
    protected KucoinMarketDataServiceRaw(KucoinExchange exchange) {
        super(exchange);
    }

    public TickerResponse getKucoinTicker(CurrencyPair pair) throws IOException {
        return (TickerResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.symbolApi.getTicker(KucoinAdapters.adaptCurrencyPair(pair)));
    }

    public AllTickersResponse getKucoinTickers() throws IOException {
        return (AllTickersResponse)KucoinExceptionClassifier.classifyingExceptions(this.symbolApi::getTickers);
    }

    public SymbolTickResponse getKucoin24hrStats(CurrencyPair pair) throws IOException {
        return (SymbolTickResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.symbolApi.getMarketStats(KucoinAdapters.adaptCurrencyPair(pair)));
    }

    public Map<String, BigDecimal> getKucoinPrices() throws IOException {
        return (Map)KucoinExceptionClassifier.classifyingExceptions(this.symbolApi::getPrices);
    }

    public List<SymbolResponse> getKucoinSymbols() throws IOException {
        return (List)KucoinExceptionClassifier.classifyingExceptions(this.symbolApi::getSymbols);
    }

    public OrderBookResponse getKucoinOrderBookPartial(CurrencyPair pair) throws IOException {
        return (OrderBookResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderBookApi.getPartOrderBookAggregated(KucoinAdapters.adaptCurrencyPair(pair)));
    }

    public OrderBookResponse getKucoinOrderBookFull(CurrencyPair pair) throws IOException {
        return (OrderBookResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderBookApi.getFullOrderBookAggregated(KucoinAdapters.adaptCurrencyPair(pair)));
    }

    public List<TradeHistoryResponse> getKucoinTrades(CurrencyPair pair) throws IOException {
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> this.historyApi.getTradeHistories(KucoinAdapters.adaptCurrencyPair(pair)));
    }
}

