/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.KucoinTradeHistoryParams;
import org.knowm.xchange.kucoin.KucoinTradeServiceRaw;
import org.knowm.xchange.kucoin.dto.response.HistOrdersResponse;
import org.knowm.xchange.kucoin.dto.response.OrderCancelResponse;
import org.knowm.xchange.kucoin.dto.response.OrderResponse;
import org.knowm.xchange.kucoin.dto.response.Pagination;
import org.knowm.xchange.kucoin.dto.response.TradeResponse;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamNextPageCursor;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KucoinTradeService
extends KucoinTradeServiceRaw
implements TradeService {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int TRADE_HISTORIES_TO_FETCH = 500;
    private static final int ORDERS_TO_FETCH = 500;
    private static final long cutoffHistOrdersMillis = Date.from(LocalDate.of(2019, 2, 18).atStartOfDay(ZoneId.of("UTC+8")).toInstant()).getTime();
    private static final long oneWeekMillis = 691199000L;

    KucoinTradeService(KucoinExchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.convertOpenOrders(this.getKucoinOpenOrders(null, 1, 500).getItems(), null);
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        String symbol = null;
        if (params instanceof OpenOrdersParamCurrencyPair) {
            OpenOrdersParamCurrencyPair pairParams = (OpenOrdersParamCurrencyPair)params;
            symbol = KucoinAdapters.adaptCurrencyPair(pairParams.getCurrencyPair());
        }
        return this.convertOpenOrders(this.getKucoinOpenOrders(symbol, 1, 500).getItems(), params);
    }

    public UserTrades getTradeHistory(TradeHistoryParams tradeHistoryParams) throws IOException {
        List userTrades;
        String nextPageCursor;
        String symbol = null;
        Long startTime = null;
        Long endTime = null;
        int page = 1;
        if (tradeHistoryParams != null) {
            TradeHistoryParamCurrencyPair params = (TradeHistoryParamCurrencyPair)tradeHistoryParams;
            symbol = KucoinAdapters.adaptCurrencyPair(params.getCurrencyPair());
            if (tradeHistoryParams instanceof TradeHistoryParamsTimeSpan) {
                if (((TradeHistoryParamsTimeSpan)tradeHistoryParams).getStartTime() != null) {
                    startTime = ((TradeHistoryParamsTimeSpan)tradeHistoryParams).getStartTime().getTime();
                }
                if (((TradeHistoryParamsTimeSpan)tradeHistoryParams).getEndTime() != null) {
                    endTime = ((TradeHistoryParamsTimeSpan)tradeHistoryParams).getEndTime().getTime();
                }
            }
            if (tradeHistoryParams instanceof TradeHistoryParamNextPageCursor) {
                nextPageCursor = ((TradeHistoryParamNextPageCursor)params).getNextPageCursor();
                try {
                    if (nextPageCursor != null) {
                        page = Integer.parseInt(nextPageCursor);
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Could not parse next page cursor [{}]. Should be a page number (integer). {}", (Object)nextPageCursor, (Object)e.getMessage());
                }
            }
        }
        if (startTime != null) {
            if (endTime == null) {
                endTime = startTime < cutoffHistOrdersMillis ? Long.valueOf(cutoffHistOrdersMillis - 1L) : Long.valueOf(startTime + 691199000L);
                this.logger.warn("End time not specified, adjusted to the following time span {} - {}", (Object)new Date(startTime), (Object)new Date(endTime));
            } else if (startTime < cutoffHistOrdersMillis && endTime > cutoffHistOrdersMillis) {
                endTime = cutoffHistOrdersMillis - 1L;
                this.logger.warn("End time after old API cutoff date, adjusted to the following time span {} - {}", (Object)new Date(startTime), (Object)new Date(endTime));
            } else if (startTime >= cutoffHistOrdersMillis && endTime - startTime > 691199000L) {
                endTime = startTime + 691199000L;
                this.logger.warn("End time more than one week from start time, adjusted to the following time span {} - {}", (Object)new Date(startTime), (Object)new Date(endTime));
            }
        }
        if (endTime != null && startTime == null && endTime > cutoffHistOrdersMillis) {
            startTime = Math.max(cutoffHistOrdersMillis, endTime - 691199000L);
            this.logger.warn("Start time not specified, adjusted to the following time span {} - {}", (Object)new Date(startTime), (Object)new Date(endTime));
        }
        if (startTime == null && endTime == null) {
            endTime = new Date().getTime();
            startTime = endTime - 691199000L;
            this.logger.warn("No start or end time for trade history request specified, adjusted to the following time span {} - {}", (Object)new Date(startTime), (Object)new Date(endTime));
        }
        nextPageCursor = null;
        if (startTime != null && startTime >= cutoffHistOrdersMillis) {
            Pagination<TradeResponse> fills = this.getKucoinFills(symbol, page, 500, startTime, endTime);
            userTrades = fills.getItems().stream().map(KucoinAdapters::adaptUserTrade).collect(Collectors.toList());
            if (fills.getTotalPage() > fills.getCurrentPage()) {
                nextPageCursor = Integer.toString(fills.getCurrentPage() + 1);
            }
        } else {
            Pagination<HistOrdersResponse> histOrders = this.getKucoinHistOrders(symbol, page, 500, startTime != null ? Long.valueOf(startTime / 1000L) : null, endTime / 1000L);
            userTrades = histOrders.getItems().stream().map(KucoinAdapters::adaptHistOrder).collect(Collectors.toList());
            if (histOrders.getTotalPage() > histOrders.getCurrentPage()) {
                nextPageCursor = Integer.toString(histOrders.getCurrentPage() + 1);
            }
        }
        return new UserTrades(userTrades, 0L, Trades.TradeSortType.SortByTimestamp, nextPageCursor);
    }

    public OpenOrdersParamCurrencyPair createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new KucoinTradeHistoryParams();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        OrderCancelResponse response = this.kucoinCancelOrder(orderId);
        return response.getCancelledOrderIds().contains(orderId);
    }

    public boolean cancelOrder(CancelOrderParams genericParams) throws IOException {
        Preconditions.checkNotNull((Object)genericParams, (Object)"No parameter supplied");
        Preconditions.checkArgument((boolean)(genericParams instanceof CancelOrderByIdParams), (Object)"Only order id parameters are currently supported.");
        CancelOrderByIdParams params = (CancelOrderByIdParams)genericParams;
        return this.cancelOrder(params.getOrderId());
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.kucoinCreateOrder(KucoinAdapters.adaptLimitOrder(limitOrder)).getOrderId();
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.kucoinCreateOrder(KucoinAdapters.adaptMarketOrder(marketOrder)).getOrderId();
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        return this.kucoinCreateOrder(KucoinAdapters.adaptStopOrder(stopOrder)).getOrderId();
    }

    private OpenOrders convertOpenOrders(Collection<OrderResponse> orders, OpenOrdersParams params) {
        ImmutableList.Builder openOrders = ImmutableList.builder();
        ImmutableList.Builder hiddenOrders = ImmutableList.builder();
        orders.stream().map(KucoinAdapters::adaptOrder).filter(o -> params == null || params.accept(o)).forEach(o -> {
            if (o instanceof LimitOrder) {
                openOrders.add((Object)((LimitOrder)o));
            } else {
                hiddenOrders.add(o);
            }
        });
        return new OpenOrders((List)openOrders.build(), (List)hiddenOrders.build());
    }

    public static interface KucoinOrderFlags
    extends Order.IOrderFlags {
        public String getClientId();
    }
}

