/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import org.knowm.xchange.kucoin.KucoinBaseService;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.dto.request.OrderCreateApiRequest;
import org.knowm.xchange.kucoin.dto.response.HistOrdersResponse;
import org.knowm.xchange.kucoin.dto.response.OrderCancelResponse;
import org.knowm.xchange.kucoin.dto.response.OrderCreateResponse;
import org.knowm.xchange.kucoin.dto.response.OrderResponse;
import org.knowm.xchange.kucoin.dto.response.Pagination;
import org.knowm.xchange.kucoin.dto.response.TradeResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinTradeServiceRaw
extends KucoinBaseService {
    protected KucoinTradeServiceRaw(KucoinExchange exchange) {
        super(exchange);
    }

    public Pagination<OrderResponse> getKucoinOpenOrders(String symbol, int page, int pageSize) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.queryOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol, null, null, "active", null, null, pageSize, page));
    }

    public Pagination<TradeResponse> getKucoinFills(String symbol, int page, int pageSize, Long startAt, Long endAt) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.fillApi.queryTrades(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol, null, null, null, startAt, endAt, pageSize, page));
    }

    public Pagination<HistOrdersResponse> getKucoinHistOrders(String symbol, int page, int pageSize, Long startAt, Long endAt) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.histOrdersApi.queryHistOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol, null, startAt, endAt, pageSize, page));
    }

    public OrderCancelResponse kucoinCancelAllOrders(String symbol) throws IOException {
        this.checkAuthenticated();
        return (OrderCancelResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.cancelOrders(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbol));
    }

    public OrderCancelResponse kucoinCancelOrder(String orderId) throws IOException {
        this.checkAuthenticated();
        return (OrderCancelResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.cancelOrder(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, orderId));
    }

    public OrderCreateResponse kucoinCreateOrder(OrderCreateApiRequest opsRequest) throws IOException {
        this.checkAuthenticated();
        return (OrderCreateResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.orderApi.createOrder(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, opsRequest));
    }
}

