/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.lgo.dto.LgoException;
import org.knowm.xchange.lgo.dto.WithCursor;
import org.knowm.xchange.lgo.dto.currency.LgoCurrencies;
import org.knowm.xchange.lgo.dto.marketdata.LgoOrderbook;
import org.knowm.xchange.lgo.dto.marketdata.LgoPriceHistory;
import org.knowm.xchange.lgo.dto.order.LgoEncryptedOrder;
import org.knowm.xchange.lgo.dto.order.LgoPlaceOrderResponse;
import org.knowm.xchange.lgo.dto.order.LgoUnencryptedOrder;
import org.knowm.xchange.lgo.dto.product.LgoProducts;
import org.knowm.xchange.lgo.dto.trade.LgoUserTrades;
import si.mazi.rescu.ParamsDigest;

@Produces(value={"application/json"})
@Path(value="/v1")
public interface Lgo {
    public static final String X_LGO_DATE = "X-LGO-DATE";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PRODUCT_ID = "product_id";
    public static final String MAX_RESULTS = "max_results";
    public static final String PAGE = "page";
    public static final String SORT = "sort";
    public static final String ORDER_ID = "order_id";
    public static final String GRANULARITY = "granularity";
    public static final String END = "end";
    public static final String START = "start";

    @GET
    @Path(value="/live/products")
    public LgoProducts getProducts(@HeaderParam(value="X-LGO-DATE") long var1, @HeaderParam(value="Authorization") ParamsDigest var3) throws IOException, LgoException;

    @GET
    @Path(value="/live/currencies")
    public LgoCurrencies getCurrencies(@HeaderParam(value="X-LGO-DATE") long var1, @HeaderParam(value="Authorization") ParamsDigest var3) throws IOException, LgoException;

    @GET
    @Path(value="/history/trades")
    public WithCursor<LgoUserTrades> getLastTrades(@HeaderParam(value="X-LGO-DATE") long var1, @HeaderParam(value="Authorization") ParamsDigest var3, @QueryParam(value="product_id") String var4, @QueryParam(value="max_results") int var5, @QueryParam(value="page") String var6, @QueryParam(value="sort") String var7) throws IOException, LgoException;

    @GET
    @Path(value="/live/products/{product_id}/book")
    public LgoOrderbook getOrderBook(@HeaderParam(value="X-LGO-DATE") long var1, @HeaderParam(value="Authorization") ParamsDigest var3, @PathParam(value="product_id") String var4) throws IOException, LgoException;

    @POST
    @Path(value="/live/orders/encrypted")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public LgoPlaceOrderResponse placeEncryptedOrder(LgoEncryptedOrder var1, @HeaderParam(value="X-LGO-DATE") long var2, @HeaderParam(value="Authorization") ParamsDigest var4) throws IOException, LgoException;

    @POST
    @Path(value="/live/orders")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public LgoPlaceOrderResponse placeUnencryptedOrder(LgoUnencryptedOrder var1, @HeaderParam(value="X-LGO-DATE") long var2, @HeaderParam(value="Authorization") ParamsDigest var4) throws IOException, LgoException;

    @DELETE
    @Path(value="/live/orders/{order_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public LgoPlaceOrderResponse placeUnencryptedCancelOrder(@HeaderParam(value="X-LGO-DATE") long var1, @HeaderParam(value="Authorization") ParamsDigest var3, @PathParam(value="order_id") String var4) throws IOException, LgoException;

    @GET
    @Path(value="/history/products/{product_id}/candles")
    public LgoPriceHistory getPriceHistory(@HeaderParam(value="X-LGO-DATE") long var1, @HeaderParam(value="Authorization") ParamsDigest var3, @PathParam(value="product_id") String var4, @QueryParam(value="start") String var5, @QueryParam(value="end") String var6, @QueryParam(value="granularity") int var7) throws IOException, LgoException;
}

