/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.FeeTier;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.lgo.dto.WithCursor;
import org.knowm.xchange.lgo.dto.currency.LgoCurrencies;
import org.knowm.xchange.lgo.dto.currency.LgoCurrency;
import org.knowm.xchange.lgo.dto.key.LgoKey;
import org.knowm.xchange.lgo.dto.marketdata.LgoOrderbook;
import org.knowm.xchange.lgo.dto.order.LgoPlaceCancelOrder;
import org.knowm.xchange.lgo.dto.order.LgoPlaceLimitOrder;
import org.knowm.xchange.lgo.dto.order.LgoPlaceMarketOrder;
import org.knowm.xchange.lgo.dto.order.LgoPlaceOrder;
import org.knowm.xchange.lgo.dto.order.LgoUnencryptedOrder;
import org.knowm.xchange.lgo.dto.product.LgoProduct;
import org.knowm.xchange.lgo.dto.product.LgoProducts;
import org.knowm.xchange.lgo.dto.trade.LgoUserTrade;
import org.knowm.xchange.lgo.dto.trade.LgoUserTrades;

public final class LgoAdapters {
    private static SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    private LgoAdapters() {
    }

    public static ExchangeMetaData adaptMetadata(ExchangeMetaData metaData, LgoProducts products, LgoCurrencies currencies) {
        Map currencyPairs = metaData.getCurrencyPairs();
        Map currency = metaData.getCurrencies();
        for (LgoCurrency lgoCurrency : currencies.getCurrencies()) {
            currency.put(Currency.getInstance((String)lgoCurrency.getCode()), new CurrencyMetaData(Integer.valueOf(lgoCurrency.getDecimals()), null));
        }
        for (LgoProduct product : products.getProducts()) {
            BigDecimal minAmount = product.getBase().getLimits().getMin();
            BigDecimal maxAmount = product.getBase().getLimits().getMax();
            Integer baseScale = ((CurrencyMetaData)currency.get(Currency.getInstance((String)product.getBase().getId()))).getScale();
            BigDecimal increment = product.getQuote().getIncrement().stripTrailingZeros();
            currencyPairs.put(LgoAdapters.toPair(product), new CurrencyPairMetaData(null, minAmount, maxAmount, null, null, baseScale, Integer.valueOf(increment.scale()), new FeeTier[0], increment, Currency.USD, true));
        }
        return metaData;
    }

    private static CurrencyPair toPair(LgoProduct product) {
        return new CurrencyPair(Currency.getInstance((String)product.getBase().getId()), Currency.getInstance((String)product.getQuote().getId()));
    }

    public static Stream<LgoKey> adaptKeysIndex(String indexFile) {
        Object[] all = indexFile.split("(true|false)");
        Spliterator spliterator = Spliterators.spliterator(all, 1280);
        return StreamSupport.stream(spliterator, true).map(LgoAdapters::parseSummary);
    }

    private static LgoKey parseSummary(String rawSummary) {
        String[] summary = rawSummary.split(" ");
        return new LgoKey(summary[0], Instant.parse(summary[1]), Instant.parse(summary[2]));
    }

    public static LgoPlaceOrder adaptLimitOrder(LimitOrder limitOrder) {
        String product = LgoAdapters.adaptCurrencyPair(limitOrder.getCurrencyPair());
        String side = LgoAdapters.adaptOrderType(limitOrder.getType());
        return new LgoPlaceLimitOrder(0L, side, product, limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), limitOrder.getTimestamp().toInstant());
    }

    public static LgoPlaceOrder adaptEncryptedMarketOrder(MarketOrder marketOrder) {
        String product = LgoAdapters.adaptCurrencyPair(marketOrder.getCurrencyPair());
        String side = LgoAdapters.adaptOrderType(marketOrder.getType());
        return new LgoPlaceMarketOrder(0L, side, product, marketOrder.getOriginalAmount(), marketOrder.getTimestamp().toInstant());
    }

    public static LgoPlaceOrder adaptEncryptedCancelOrder(String orderId, Date date) {
        return new LgoPlaceCancelOrder(0L, orderId, date.toInstant());
    }

    public static LgoUnencryptedOrder adaptUnencryptedLimitOrder(LimitOrder limitOrder) {
        String product = LgoAdapters.adaptCurrencyPair(limitOrder.getCurrencyPair());
        String side = LgoAdapters.adaptOrderType(limitOrder.getType());
        return new LgoUnencryptedOrder("L", side, product, limitOrder.getOriginalAmount().toString(), limitOrder.getLimitPrice().toString(), limitOrder.getTimestamp().getTime());
    }

    public static LgoUnencryptedOrder adaptUnencryptedMarketOrder(MarketOrder marketOrder) {
        String product = LgoAdapters.adaptCurrencyPair(marketOrder.getCurrencyPair());
        String side = LgoAdapters.adaptOrderType(marketOrder.getType());
        return new LgoUnencryptedOrder("M", side, product, marketOrder.getOriginalAmount().toString(), null, marketOrder.getTimestamp().getTime());
    }

    private static String adaptOrderType(Order.OrderType type) {
        return type == Order.OrderType.BID ? "B" : "S";
    }

    public static String adaptCurrencyPair(CurrencyPair currencyPair) {
        return String.format("%s-%s", currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode());
    }

    private static UserTrade adaptUserTrade(LgoUserTrade lgoUserTrade) {
        Order.OrderType type = LgoAdapters.adaptUserTradeType(lgoUserTrade);
        CurrencyPair currencyPair = LgoAdapters.adaptProductId(lgoUserTrade.getProductId());
        Date creationDate = lgoUserTrade.getCreationDate();
        return new UserTrade.Builder().type(type).originalAmount(lgoUserTrade.getQuantity()).currencyPair(currencyPair).price(lgoUserTrade.getPrice()).timestamp(creationDate).id(lgoUserTrade.getId()).orderId(lgoUserTrade.getOrderId()).feeAmount(lgoUserTrade.getFees()).feeCurrency(currencyPair.counter).build();
    }

    static CurrencyPair adaptProductId(String productId) {
        String[] pair = productId.split("-");
        return new CurrencyPair(pair[0], pair[1]);
    }

    static Order.OrderType adaptUserTradeType(LgoUserTrade trade) {
        boolean bidSide = LgoAdapters.buyerTaker(trade) || LgoAdapters.sellerMaker(trade);
        return bidSide ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    private static boolean sellerMaker(LgoUserTrade trade) {
        return trade.getSide().equals("S") && trade.getLiquidity().equals("M");
    }

    private static boolean buyerTaker(LgoUserTrade trade) {
        return trade.getSide().equals("B") && trade.getLiquidity().equals("T");
    }

    public static UserTrades adaptUserTrades(WithCursor<LgoUserTrades> lastTrades) {
        List trades = lastTrades.getResult().getTrades().stream().map(LgoAdapters::adaptUserTrade).collect(Collectors.toList());
        return new UserTrades(trades, 0L, Trades.TradeSortType.SortByID, lastTrades.getNextPage());
    }

    public static OrderBook adaptOrderBook(LgoOrderbook ob, CurrencyPair pair) {
        List bids = ob.getBids().stream().map(e -> LgoAdapters.adaptEntryToLimitOrder(e, Order.OrderType.BID, pair)).collect(Collectors.toList());
        List asks = ob.getAsks().stream().map(e -> LgoAdapters.adaptEntryToLimitOrder(e, Order.OrderType.ASK, pair)).collect(Collectors.toList());
        return new OrderBook(null, asks, bids, true);
    }

    public static LimitOrder adaptEntryToLimitOrder(Object[] entry, Order.OrderType bid, CurrencyPair pair) {
        return new LimitOrder(bid, new BigDecimal(entry[1].toString()), pair, null, null, new BigDecimal(entry[0].toString()));
    }

    public static String adaptDateParam(Date date) {
        return ISO_DATE_FORMAT.format(date);
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

