/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.lgo.LgoAdapters;
import org.knowm.xchange.lgo.LgoEnv;
import org.knowm.xchange.lgo.LgoErrorAdapter;
import org.knowm.xchange.lgo.dto.LgoException;
import org.knowm.xchange.lgo.dto.currency.LgoCurrencies;
import org.knowm.xchange.lgo.dto.product.LgoProducts;
import org.knowm.xchange.lgo.service.LgoKeyService;
import org.knowm.xchange.lgo.service.LgoMarketDataService;
import org.knowm.xchange.lgo.service.LgoSignatureService;
import org.knowm.xchange.lgo.service.LgoTradeService;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.utils.nonce.CurrentTimeNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class LgoExchange
extends BaseExchange {
    private SynchronizedValueFactory<Long> nonceFactory = new CurrentTimeNonceFactory();
    private LgoSignatureService signatureService;
    private LgoProducts products;
    private LgoCurrencies currencies;

    protected void initServices() {
        this.signatureService = LgoSignatureService.createInstance(this.getExchangeSpecification());
        this.marketDataService = new LgoMarketDataService(this);
        this.tradeService = new LgoTradeService(this, new LgoKeyService(this.getExchangeSpecification()));
        this.accountService = new AccountService(){};
    }

    public void remoteInit() throws IOException {
        try {
            this.products = this.getMarketDataService().getProducts();
            this.currencies = this.getMarketDataService().getCurrencies();
        }
        catch (LgoException e) {
            throw LgoErrorAdapter.adapt(e);
        }
        LgoAdapters.adaptMetadata(this.getExchangeMetaData(), this.products, this.currencies);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        return LgoEnv.prod();
    }

    public LgoMarketDataService getMarketDataService() {
        return (LgoMarketDataService)this.marketDataService;
    }

    public LgoTradeService getTradeService() {
        return (LgoTradeService)super.getTradeService();
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public LgoProducts getProducts() {
        return this.products;
    }

    public LgoCurrencies getCurrencies() {
        return this.currencies;
    }

    public LgoSignatureService getSignatureService() {
        return this.signatureService;
    }
}

