/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo.dto.order;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.StringJoiner;
import org.knowm.xchange.lgo.dto.order.LgoPlaceOrder;

public class LgoPlaceLimitOrder
extends LgoPlaceOrder {
    private final String side;
    private final String productId;
    private final BigDecimal quantity;
    private final BigDecimal price;

    public LgoPlaceLimitOrder(long reference, String side, String productId, BigDecimal quantity, BigDecimal price, Instant timestamp) {
        super(reference, timestamp);
        this.side = side;
        this.productId = productId;
        this.quantity = quantity;
        this.price = price;
    }

    @Override
    public String toPayload() {
        return new StringJoiner(",").add("L").add(this.side).add(this.productId).add(this.quantity.toPlainString()).add(this.price == null ? "" : this.price.toPlainString()).add("gtc").add(String.valueOf(this.getTimestamp().toEpochMilli())).toString();
    }

    public String getSide() {
        return this.side;
    }

    public String getProductId() {
        return this.productId;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BigDecimal getPrice() {
        return this.price;
    }
}

