/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo.dto.order;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.StringJoiner;
import org.knowm.xchange.lgo.dto.order.LgoPlaceOrder;

public class LgoPlaceMarketOrder
extends LgoPlaceOrder {
    private final String side;
    private final String productId;
    private final BigDecimal quantity;

    public LgoPlaceMarketOrder(long reference, String side, String productId, BigDecimal quantity, Instant timestamp) {
        super(reference, timestamp);
        this.side = side;
        this.productId = productId;
        this.quantity = quantity;
    }

    @Override
    public String toPayload() {
        return new StringJoiner(",").add("M").add(this.side).add(this.productId).add(this.quantity.toPlainString()).add("").add("").add(String.valueOf(this.getTimestamp().toEpochMilli())).toString();
    }

    public String getSide() {
        return this.side;
    }

    public String getProductId() {
        return this.productId;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }
}

