/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo.service;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.lgo.CertificateAuthority;
import org.knowm.xchange.lgo.LgoAdapters;
import org.knowm.xchange.lgo.dto.key.LgoKey;
import org.knowm.xchange.lgo.service.CryptoUtils;
import si.mazi.rescu.RestProxyFactory;

public class LgoKeyService {
    private final CertificateAuthority proxy;
    private LgoKey currentKey;

    public LgoKeyService(ExchangeSpecification exchangeSpecification) {
        this.proxy = (CertificateAuthority)RestProxyFactory.createProxy(CertificateAuthority.class, (String)exchangeSpecification.getExchangeSpecificParametersItem("Keys_Url").toString());
    }

    public LgoKey selectKey() {
        if (this.mustFetchNewKey()) {
            this.fetchKey();
        }
        return this.currentKey;
    }

    private boolean mustFetchNewKey() {
        return this.currentKey == null || Instant.now().minus(10L, ChronoUnit.MINUTES).isAfter(this.currentKey.getDisabledAt());
    }

    private void fetchKey() {
        this.currentKey = LgoAdapters.adaptKeysIndex(this.proxy.fetchIndex()).filter(k -> {
            Instant now = Instant.now();
            return now.isBefore(k.getDisabledAt()) && now.isAfter(k.getEnabledAt());
        }).max(Comparator.comparing(LgoKey::getDisabledAt)).orElseThrow(() -> new ExchangeException("Can't find a proper key"));
        String value = this.proxy.fetchKey(this.currentKey.getId());
        this.currentKey.setValue(CryptoUtils.parsePublicKey(value));
    }
}

