/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo.service;

import java.io.IOException;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.lgo.LgoAdapters;
import org.knowm.xchange.lgo.LgoExchange;
import org.knowm.xchange.lgo.dto.currency.LgoCurrencies;
import org.knowm.xchange.lgo.dto.marketdata.LgoGranularity;
import org.knowm.xchange.lgo.dto.marketdata.LgoOrderbook;
import org.knowm.xchange.lgo.dto.marketdata.LgoPriceHistory;
import org.knowm.xchange.lgo.dto.product.LgoProducts;
import org.knowm.xchange.lgo.service.LgoBaseService;

public class LgoMarketDataServiceRaw
extends LgoBaseService {
    public LgoMarketDataServiceRaw(LgoExchange exchange) {
        super(exchange);
    }

    public LgoProducts getProducts() throws IOException {
        return this.proxy.getProducts((Long)((LgoExchange)this.exchange).getNonceFactory().createValue(), ((LgoExchange)this.exchange).getSignatureService());
    }

    public LgoCurrencies getCurrencies() throws IOException {
        return this.proxy.getCurrencies((Long)((LgoExchange)this.exchange).getNonceFactory().createValue(), ((LgoExchange)this.exchange).getSignatureService());
    }

    public LgoOrderbook getLgoOrderBook(CurrencyPair product) throws IOException {
        return this.proxy.getOrderBook((Long)((LgoExchange)this.exchange).getNonceFactory().createValue(), ((LgoExchange)this.exchange).getSignatureService(), LgoAdapters.adaptCurrencyPair(product));
    }

    public LgoPriceHistory getLgoPriceHistory(CurrencyPair product, Date startTime, Date endTime, LgoGranularity granularity) throws IOException {
        return this.proxy.getPriceHistory((Long)((LgoExchange)this.exchange).getNonceFactory().createValue(), ((LgoExchange)this.exchange).getSignatureService(), LgoAdapters.adaptCurrencyPair(product), LgoAdapters.adaptDateParam(startTime), LgoAdapters.adaptDateParam(endTime), granularity.asSeconds());
    }
}

