/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo.service;

import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.lgo.LgoEnv;
import org.knowm.xchange.lgo.dto.order.LgoOrderSignature;
import org.knowm.xchange.lgo.service.LgoSignatureServiceLocalRsa;
import org.knowm.xchange.lgo.service.LgoSignatureServicePassthroughs;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public interface LgoSignatureService
extends ParamsDigest {
    public static LgoSignatureService createInstance(ExchangeSpecification specification) {
        LgoEnv.SignatureService implementation = specification.getExchangeSpecificParameters().getOrDefault("Signature_Service", LgoEnv.SignatureService.LOCAL_RSA);
        switch (implementation) {
            case LOCAL_RSA: {
                return new LgoSignatureServiceLocalRsa(specification.getApiKey(), specification.getSecretKey());
            }
            case PASSTHROUGHS: {
                return new LgoSignatureServicePassthroughs(specification.getUserName(), specification.getApiKey(), specification.getSecretKey());
            }
        }
        throw new ExchangeException("Unknown signature service implementation " + (Object)((Object)implementation));
    }

    default public String digestParams(RestInvocation restInvocation) {
        String rawUrl = restInvocation.getInvocationUrl();
        String timestamp = restInvocation.getHttpHeadersFromParams().getOrDefault("X-LGO-DATE", "");
        if (this.needsBodySignature(restInvocation)) {
            return this.digestSignedUrlAndBodyHeader(rawUrl, timestamp, restInvocation.getRequestBody());
        }
        return this.digestSignedUrlHeader(rawUrl, timestamp);
    }

    default public boolean needsBodySignature(RestInvocation restInvocation) {
        return restInvocation.getPath().equals("/v1/live/orders") && restInvocation.getHttpMethod().equals(HttpMethod.POST.name());
    }

    public String digestSignedUrlHeader(String var1, String var2);

    public String digestSignedUrlAndBodyHeader(String var1, String var2, String var3);

    public LgoOrderSignature signOrder(String var1);
}

