/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.lgo.service;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import lombok.NonNull;
import org.knowm.xchange.lgo.dto.order.LgoOrderSignature;
import org.knowm.xchange.lgo.service.CryptoUtils;
import org.knowm.xchange.lgo.service.LgoSignatureService;

public class LgoSignatureServiceLocalRsa
implements LgoSignatureService {
    private final String apiKey;
    private final String privKey;

    LgoSignatureServiceLocalRsa(@NonNull String apiKey, @NonNull String privKey) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (privKey == null) {
            throw new NullPointerException("privKey is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.privKey = CryptoUtils.parsePrivateKey(privKey);
    }

    private static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    @Override
    public String digestSignedUrlAndBodyHeader(String url, String timestamp, String body) {
        try {
            String urlToSign = this.removeProtocol(url);
            String signatureBaseString = String.format("%s\n%s\n%s", timestamp, urlToSign, body);
            return this.buildHeader(this.signSHA256RSA(signatureBaseString));
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing request", e);
        }
    }

    @Override
    public String digestSignedUrlHeader(String url, String timestamp) {
        try {
            String urlToSign = this.removeProtocol(url);
            String signatureBaseString = String.format("%s\n%s", timestamp, urlToSign);
            return this.buildHeader(this.signSHA256RSA(signatureBaseString));
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing request", e);
        }
    }

    private String buildHeader(String signed) {
        return String.format("LGO %s:%s", this.apiKey, signed);
    }

    private String removeProtocol(String urlToSign) {
        return urlToSign.replace("http://", "").replace("https://", "").replace("wss://", "").replace("ws://", "");
    }

    @Override
    public LgoOrderSignature signOrder(String encryptedOrder) {
        try {
            return new LgoOrderSignature(this.signSHA256RSA(encryptedOrder));
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing order", e);
        }
    }

    private String signSHA256RSA(String input) throws Exception {
        byte[] b1 = Base64.getDecoder().decode(this.privKey);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(b1);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        Signature privateSignature = Signature.getInstance("SHA256withRSA");
        privateSignature.initSign(kf.generatePrivate(spec));
        privateSignature.update(input.getBytes(StandardCharsets.UTF_8));
        return LgoSignatureServiceLocalRsa.byteArrayToHex(privateSignature.sign());
    }
}

