/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin;

import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.okcoin.v3.dto.account.OkexDepositRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexFundingAccountRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexSpotAccountRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalRecord;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexSpotTicker;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesAccountsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexOpenOrder;
import org.knowm.xchange.okcoin.v3.dto.trade.Side;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapAccountsResponse;

public class OkexAdaptersV3 {
    public static Balance convert(OkexFundingAccountRecord rec) {
        return new Balance.Builder().currency(Currency.getInstance((String)rec.getCurrency())).available(rec.getAvailable()).frozen(rec.getBalance().subtract(rec.getAvailable())).total(rec.getBalance()).build();
    }

    public static Balance convert(OkexSpotAccountRecord rec) {
        return new Balance.Builder().currency(Currency.getInstance((String)rec.getCurrency())).available(rec.getAvailable()).frozen(rec.getBalance().subtract(rec.getAvailable())).total(rec.getBalance()).build();
    }

    public static Balance convert(String currency, FuturesAccountsResponse.FuturesAccount acc) {
        return new Balance.Builder().currency(Currency.getInstance((String)currency.toUpperCase())).total(acc.getEquity()).build();
    }

    public static Balance convert(SwapAccountsResponse.SwapAccountInfo rec) {
        return new Balance.Builder().currency(OkexAdaptersV3.toPair((String)rec.getInstrumentId()).base).total(rec.getEquity()).build();
    }

    public static String toSpotInstrument(CurrencyPair pair) {
        return pair == null ? null : pair.base.getCurrencyCode() + "-" + pair.counter.getCurrencyCode();
    }

    public static CurrencyPair toPair(String instrument) {
        String[] split = instrument.split("-");
        if (split == null || split.length < 2) {
            throw new ExchangeException("Not supported instrument: " + instrument);
        }
        return new CurrencyPair(split[0], split[1]);
    }

    public static Ticker convert(OkexSpotTicker i) {
        return new Ticker.Builder().currencyPair(OkexAdaptersV3.toPair(i.getInstrumentId())).last(i.getLast()).bid(i.getBid()).ask(i.getAsk()).volume(i.getBaseVolume24h()).quoteVolume(i.getQuoteVolume24h()).timestamp(i.getTimestamp()).build();
    }

    public static LimitOrder convert(OkexOpenOrder o) {
        return new LimitOrder.Builder(o.getSide() == Side.sell ? Order.OrderType.ASK : Order.OrderType.BID, OkexAdaptersV3.toPair(o.getInstrumentId())).id(o.getOrderId()).limitPrice(o.getPrice()).originalAmount(o.getSize()).timestamp(o.getCreatedAt()).build();
    }

    public static FundingRecord adaptFundingRecord(OkexWithdrawalRecord r) {
        return new FundingRecord.Builder().setAddress(r.getTo()).setAmount(r.getAmount()).setCurrency(Currency.getInstance((String)r.getCurrency())).setDate(r.getTimestamp()).setInternalId(r.getWithdrawalId()).setStatus(OkexAdaptersV3.convertWithdrawalStatus(r.getStatus())).setBlockchainTransactionHash(r.getTxid()).setType(FundingRecord.Type.WITHDRAWAL).build();
    }

    private static FundingRecord.Status convertWithdrawalStatus(String status) {
        switch (status) {
            case "-3": 
            case "-2": {
                return FundingRecord.Status.CANCELLED;
            }
            case "-1": {
                return FundingRecord.Status.FAILED;
            }
            case "0": 
            case "1": 
            case "3": 
            case "4": 
            case "5": {
                return FundingRecord.Status.PROCESSING;
            }
            case "2": {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new ExchangeException("Unknown withdrawal status: " + status);
    }

    public static FundingRecord adaptFundingRecord(OkexDepositRecord r) {
        return new FundingRecord.Builder().setAddress(r.getTo()).setAmount(r.getAmount()).setCurrency(Currency.getInstance((String)r.getCurrency())).setDate(r.getTimestamp()).setStatus(OkexAdaptersV3.convertDepositStatus(r.getStatus())).setBlockchainTransactionHash(r.getTxid()).setType(FundingRecord.Type.DEPOSIT).build();
    }

    private static FundingRecord.Status convertDepositStatus(String status) {
        switch (status) {
            case "0": 
            case "1": 
            case "6": {
                return FundingRecord.Status.PROCESSING;
            }
            case "2": {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new ExchangeException("Unknown deposit status: " + status);
    }
}

