/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class OkexDigestV3
extends BaseParamsDigest {
    private static final String UTF_8 = "UTF-8";

    public OkexDigestV3(String secretKey) {
        super(secretKey, "HmacSHA256");
    }

    public String digestParams(RestInvocation ri) {
        byte[] signSHA256;
        String timestamp = (String)ri.getHttpHeadersFromParams().get("OK-ACCESS-TIMESTAMP");
        String toSign = timestamp + ri.getHttpMethod() + ri.getPath() + (ri.getQueryString() != null && !ri.getQueryString().isEmpty() ? "?" + ri.getQueryString() : "") + (ri.getRequestBody() == null ? "" : ri.getRequestBody());
        try {
            signSHA256 = this.getMac().doFinal(toSign.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException | IllegalStateException e) {
            throw new ExchangeException("Could not sign the request", (Throwable)e);
        }
        return Base64.getEncoder().encodeToString(signSHA256);
    }
}

