/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.okcoin.v3.dto.account.FuturesLeverageResponse;
import org.knowm.xchange.okcoin.v3.dto.account.MarginAccountResponse;
import org.knowm.xchange.okcoin.v3.dto.account.MarginAccountSettingsRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexDepositRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexFundingAccountRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexSpotAccountRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalRequest;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalResponse;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexFutureInstrument;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexFutureTicker;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexSpotInstrument;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexSpotTicker;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexSwapInstrument;
import org.knowm.xchange.okcoin.v3.dto.marketdata.OkexSwapTicker;
import org.knowm.xchange.okcoin.v3.dto.trade.FundsTransferRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.FundsTransferResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesAccountsByCurrencyResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesAccountsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesMultipleOrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesMultipleOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesOpenOrdersResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesPositionsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginBorrowRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginBorrowResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginRepaymentRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginRepaymentResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginSetLeverageRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexFuturesTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexOpenOrder;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexSwapTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderBatchCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderPlacementResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SpotOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapAccountsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapFuturesMultipleOrderPlacementResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapMultipleOrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapMultipleOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapOpenOrdersResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapOrderBatchCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapPositionsEntry;
import org.knowm.xchange.okcoin.v3.service.OkexException;
import si.mazi.rescu.ParamsDigest;

@Path(value="/api")
@Produces(value={"application/json"})
public interface OkexV3 {
    public static final String OK_ACCESS_PASSPHRASE = "OK-ACCESS-PASSPHRASE";
    public static final String OK_ACCESS_KEY = "OK-ACCESS-KEY";
    public static final String OK_ACCESS_SIGN = "OK-ACCESS-SIGN";
    public static final String OK_ACCESS_TIMESTAMP = "OK-ACCESS-TIMESTAMP";

    @GET
    @Path(value="/account/v3/wallet")
    public List<OkexFundingAccountRecord> fundingAccountInformation(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @POST
    @Path(value="/account/v3/transfer")
    @Consumes(value={"application/json"})
    public FundsTransferResponse fundsTransfer(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, FundsTransferRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/account/v3/withdrawal")
    @Consumes(value={"application/json"})
    public OkexWithdrawalResponse withdrawal(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, OkexWithdrawalRequest var5) throws IOException, OkexException;

    @GET
    @Path(value="/account/v3/withdrawal/history")
    public List<OkexWithdrawalRecord> recentWithdrawalHistory(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @GET
    @Path(value="/account/v3/deposit/history")
    public List<OkexDepositRecord> recentDepositHistory(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @GET
    @Path(value="/spot/v3/accounts")
    public List<OkexSpotAccountRecord> spotTradingAccount(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @POST
    @Path(value="/spot/v3/orders")
    @Consumes(value={"application/json"})
    public OrderPlacementResponse spotPlaceOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, SpotOrderPlacementRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/spot/v3/batch_orders")
    @Consumes(value={"application/json"})
    public Map<String, List<OrderPlacementResponse>> spotPlaceMultipleOrders(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, List<SpotOrderPlacementRequest> var5) throws IOException, OkexException;

    @POST
    @Path(value="/spot/v3/cancel_orders/{order_id}")
    @Consumes(value={"application/json"})
    public OrderCancellationResponse spotCancelOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="order_id") String var5, OrderCancellationRequest var6) throws IOException, OkexException;

    @POST
    @Path(value="/spot/v3/cancel_batch_orders")
    @Consumes(value={"application/json"})
    public Map<String, List<OrderCancellationResponse>> spotCancelMultipleOrders(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, List<OrderBatchCancellationRequest> var5) throws IOException, OkexException;

    @GET
    @Path(value="/spot/v3/orders")
    public List<OkexOpenOrder> getSpotOrderList(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @QueryParam(value="instrument_id") String var5, @QueryParam(value="from") String var6, @QueryParam(value="to") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="state") String var9) throws IOException, OkexException;

    @GET
    @Path(value="/spot/v3/fills")
    public List<OkexTransaction> getSpotTransactionDetails(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @QueryParam(value="order_id") String var5, @QueryParam(value="instrument_id") String var6, @QueryParam(value="from") String var7, @QueryParam(value="to") String var8, @QueryParam(value="limit") Integer var9) throws IOException, OkexException;

    @GET
    @Path(value="/spot/v3/instruments")
    public List<OkexSpotInstrument> getAllSpotInstruments() throws IOException, OkexException;

    @GET
    @Path(value="/spot/v3/instruments/ticker")
    public List<OkexSpotTicker> getAllSpotTickers() throws IOException, OkexException;

    @GET
    @Path(value="/spot/v3/instruments/{instrument_id}/ticker")
    public OkexSpotTicker getSpotTicker(@PathParam(value="instrument_id") String var1) throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/instruments")
    public List<OkexFutureInstrument> getAllFutureInstruments() throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/instruments/ticker")
    public List<OkexFutureTicker> getAllFutureTickers() throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/position")
    public FuturesPositionsResponse getFuturesPositions(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/accounts")
    public FuturesAccountsResponse getFuturesAccounts(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/accounts/{currency}")
    public FuturesAccountsByCurrencyResponse getFuturesAccounts(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="currency") String var5) throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/accounts/{currency}/leverage")
    public FuturesLeverageResponse getFuturesLeverage(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="currency") String var5) throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/orders/{instrument_id}")
    public FuturesOpenOrdersResponse getFuturesOrderList(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, @QueryParam(value="from") String var6, @QueryParam(value="to") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="state") String var9) throws IOException, OkexException;

    @POST
    @Path(value="/futures/v3/order")
    @Consumes(value={"application/json"})
    public OrderPlacementResponse futuresPlaceOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, FuturesOrderPlacementRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/futures/v3/orders")
    @Consumes(value={"application/json"})
    public SwapFuturesMultipleOrderPlacementResponse futuresPlaceMultipleOrders(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, FuturesMultipleOrderPlacementRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/futures/v3/cancel_order/{instrument_id}/{order_id}")
    @Consumes(value={"application/json"})
    public OrderCancellationResponse futuresCancelOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, @PathParam(value="order_id") String var6) throws IOException, OkexException;

    @POST
    @Path(value="/futures/v3/cancel_batch_orders/{instrument_id}")
    @Consumes(value={"application/json"})
    public FuturesMultipleOrderCancellationResponse futuresCancelMultipleOrders(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, OrderBatchCancellationRequest var6) throws IOException, OkexException;

    @GET
    @Path(value="/futures/v3/fills")
    public List<OkexFuturesTransaction> getFuturesTransactionDetails(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @QueryParam(value="order_id") String var5, @QueryParam(value="instrument_id") String var6, @QueryParam(value="from") String var7, @QueryParam(value="to") String var8, @QueryParam(value="limit") Integer var9) throws IOException, OkexException;

    @GET
    @Path(value="/swap/v3/instruments")
    public List<OkexSwapInstrument> getAllSwapInstruments() throws IOException, OkexException;

    @GET
    @Path(value="/swap/v3/instruments/ticker")
    public List<OkexSwapTicker> getAllSwapTickers() throws IOException, OkexException;

    @GET
    @Path(value="/swap/v3/orders/{instrument_id}")
    public SwapOpenOrdersResponse getSwapOrderList(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, @QueryParam(value="from") String var6, @QueryParam(value="to") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="state") String var9) throws IOException, OkexException;

    @GET
    @Path(value="/swap/v3/position")
    public List<SwapPositionsEntry> getSwapPositions(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @GET
    @Path(value="/swap/v3/accounts")
    public SwapAccountsResponse getSwapAccounts(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @POST
    @Path(value="/swap/v3/order")
    @Consumes(value={"application/json"})
    public OrderPlacementResponse swapPlaceOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, SwapOrderPlacementRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/swap/v3/orders")
    @Consumes(value={"application/json"})
    public SwapFuturesMultipleOrderPlacementResponse swapPlaceMultipleOrders(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, SwapMultipleOrderPlacementRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/swap/v3/cancel_order/{instrument_id}/{order_id}")
    @Consumes(value={"application/json"})
    public OrderCancellationResponse swapCancelOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, @PathParam(value="order_id") String var6) throws IOException, OkexException;

    @POST
    @Path(value="/swap/v3/cancel_batch_orders/{instrument_id}")
    @Consumes(value={"application/json"})
    public SwapMultipleOrderCancellationResponse swapCancelMultipleOrders(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, SwapOrderBatchCancellationRequest var6) throws IOException, OkexException;

    @GET
    @Path(value="/swap/v3/fills")
    public List<OkexSwapTransaction> getSwapTransactionDetails(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @QueryParam(value="order_id") String var5, @QueryParam(value="instrument_id") String var6, @QueryParam(value="from") String var7, @QueryParam(value="to") String var8, @QueryParam(value="limit") Integer var9) throws IOException, OkexException;

    @GET
    @Path(value="/margin/v3/accounts")
    public MarginAccountResponse[] marginAccounts(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @GET
    @Path(value="/margin/v3/accounts/availability")
    public List<MarginAccountSettingsRecord> marginAccountsSettings(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4) throws IOException, OkexException;

    @POST
    @Path(value="/margin/v3/orders")
    @Consumes(value={"application/json"})
    public OrderPlacementResponse marginPlaceOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, SpotOrderPlacementRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/margin/v3/accounts/{instrument_id}/leverage")
    @Consumes(value={"application/json"})
    public OkexResponse setLeverage(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, MarginSetLeverageRequest var6) throws IOException, OkexException;

    @POST
    @Path(value="/margin/v3/accounts/borrow")
    @Consumes(value={"application/json"})
    public MarginBorrowResponse marginBorrow(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, MarginBorrowRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/margin/v3/accounts/repayment")
    @Consumes(value={"application/json"})
    public MarginRepaymentResponse marginRepayment(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, MarginRepaymentRequest var5) throws IOException, OkexException;

    @POST
    @Path(value="/margin/v3/cancel_order/{instrument_id}/{order_id}")
    @Consumes(value={"application/json"})
    public OrderCancellationResponse marginCancelOrder(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @PathParam(value="instrument_id") String var5, @PathParam(value="order_id") String var6) throws IOException, OkexException;

    @GET
    @Path(value="/margin/v3/orders")
    public List<OkexOpenOrder> getMarginOrderList(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @QueryParam(value="instrument_id") String var5, @QueryParam(value="from") String var6, @QueryParam(value="to") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="state") String var9) throws IOException, OkexException;

    @GET
    @Path(value="/margin/v3/fills")
    public List<OkexTransaction> getMarginTransactionDetails(@HeaderParam(value="OK-ACCESS-KEY") String var1, @HeaderParam(value="OK-ACCESS-SIGN") ParamsDigest var2, @HeaderParam(value="OK-ACCESS-TIMESTAMP") String var3, @HeaderParam(value="OK-ACCESS-PASSPHRASE") String var4, @QueryParam(value="order_id") String var5, @QueryParam(value="instrument_id") String var6, @QueryParam(value="from") String var7, @QueryParam(value="to") String var8, @QueryParam(value="limit") Integer var9) throws IOException, OkexException;
}

