/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.okcoin.OkCoin;
import org.knowm.xchange.okcoin.OkCoinDigest;
import org.knowm.xchange.okcoin.OkCoinUtils;
import org.knowm.xchange.okcoin.dto.trade.OkCoinErrorResult;
import org.knowm.xchange.okcoin.service.OkCoinBaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class OKCoinBaseTradeService
extends OkCoinBaseService {
    protected final OkCoin okCoin;
    protected final String apikey;
    protected final String secretKey;

    protected OKCoinBaseTradeService(Exchange exchange) {
        super(exchange);
        this.okCoin = (OkCoin)RestProxyFactory.createProxy(OkCoin.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.apikey = exchange.getExchangeSpecification().getApiKey();
        this.secretKey = exchange.getExchangeSpecification().getSecretKey();
    }

    protected OkCoinDigest signatureCreator() {
        return new OkCoinDigest(this.apikey, this.secretKey);
    }

    protected static <T extends OkCoinErrorResult> T returnOrThrow(T t) {
        if (t.isResult()) {
            return t;
        }
        throw new ExchangeException(OkCoinUtils.getErrorMessage(t.getErrorCode()));
    }
}

