/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.dto.account.OKCoinWithdraw;
import org.knowm.xchange.okcoin.dto.account.OkCoinAccountRecords;
import org.knowm.xchange.okcoin.service.OkCoinAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class OkCoinAccountService
extends OkCoinAccountServiceRaw
implements AccountService {
    public OkCoinAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return OkCoinAdapters.adaptAccountInfo(this.getUserInfo());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        boolean useIntl = this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("Use_Intl").equals(true);
        String currencySymbol = OkCoinAdapters.adaptSymbol(new CurrencyPair(currency, useIntl ? Currency.USD : Currency.CNY));
        BigDecimal staticFee = ((CurrencyMetaData)this.exchange.getExchangeMetaData().getCurrencies().get(currency)).getWithdrawalFee();
        if (staticFee == null) {
            throw new IllegalArgumentException("Unsupported withdraw currency " + currency);
        }
        DecimalFormat format = new DecimalFormat("0.####");
        String fee = format.format(staticFee);
        OKCoinWithdraw result = this.withdraw(currencySymbol, address, amount, "address", fee);
        if (result != null) {
            return result.getWithdrawId();
        }
        return "";
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new OkCoinFundingHistoryParams(null, null, null, null);
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        String symbol = null;
        if (params instanceof TradeHistoryParamCurrency && ((TradeHistoryParamCurrency)params).getCurrency() != null) {
            symbol = OkCoinAdapters.adaptCurrencyToAccountRecordPair(((TradeHistoryParamCurrency)params).getCurrency());
        }
        if (symbol == null) {
            throw new ExchangeException("Symbol must be supplied");
        }
        Integer pageLength = 50;
        Integer pageNumber = null;
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging pagingParams = (TradeHistoryParamPaging)params;
            if (pagingParams.getPageLength() != null && (pageLength = pagingParams.getPageLength()) > 50) {
                pageLength = 50;
            }
            pageNumber = pagingParams.getPageNumber() != null ? pagingParams.getPageNumber() : 1;
        }
        FundingRecord.Type type = null;
        if (params instanceof HistoryParamsFundingType) {
            type = ((HistoryParamsFundingType)params).getType();
        }
        ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
        if (type == null || type == FundingRecord.Type.DEPOSIT) {
            OkCoinAccountRecords depositRecord = this.getAccountRecords(symbol, "0", String.valueOf(pageNumber), String.valueOf(pageLength));
            result.addAll(OkCoinAdapters.adaptFundingHistory(depositRecord, FundingRecord.Type.DEPOSIT));
        }
        if (type == null || type == FundingRecord.Type.WITHDRAWAL) {
            OkCoinAccountRecords withdrawalRecord = this.getAccountRecords(symbol, "1", String.valueOf(pageNumber), String.valueOf(pageLength));
            result.addAll(OkCoinAdapters.adaptFundingHistory(withdrawalRecord, FundingRecord.Type.WITHDRAWAL));
        }
        return result;
    }

    public static class OkCoinFundingHistoryParams
    extends DefaultTradeHistoryParamPaging
    implements TradeHistoryParamCurrency,
    HistoryParamsFundingType {
        private Currency currency;
        private FundingRecord.Type type;

        public OkCoinFundingHistoryParams(Integer pageNumber, Integer pageLength, Currency currency, FundingRecord.Type type) {
            super(pageLength, pageNumber);
            this.currency = currency;
            this.type = type;
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public FundingRecord.Type getType() {
            return this.type;
        }

        public void setType(FundingRecord.Type type) {
            this.type = type;
        }
    }
}

