/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.okcoin.dto.account.OKCoinWithdraw;
import org.knowm.xchange.okcoin.dto.account.OkCoinAccountRecords;
import org.knowm.xchange.okcoin.dto.account.OkCoinFuturesUserInfoCross;
import org.knowm.xchange.okcoin.dto.account.OkCoinFuturesUserInfoFixed;
import org.knowm.xchange.okcoin.dto.account.OkCoinUserInfo;
import org.knowm.xchange.okcoin.service.OKCoinBaseTradeService;

public class OkCoinAccountServiceRaw
extends OKCoinBaseTradeService {
    private final String tradepwd;

    protected OkCoinAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.tradepwd = (String)exchange.getExchangeSpecification().getExchangeSpecificParametersItem("tradepwd");
    }

    public OkCoinUserInfo getUserInfo() throws IOException {
        OkCoinUserInfo userInfo = this.okCoin.getUserInfo(this.apikey, this.signatureCreator());
        return OkCoinAccountServiceRaw.returnOrThrow(userInfo);
    }

    public OkCoinFuturesUserInfoCross getFutureUserInfo() throws IOException {
        OkCoinFuturesUserInfoCross futuresUserInfoCross = this.okCoin.getFuturesUserInfoCross(this.apikey, this.signatureCreator());
        return OkCoinAccountServiceRaw.returnOrThrow(futuresUserInfoCross);
    }

    public OkCoinFuturesUserInfoFixed getFuturesUserInfoFixed() throws IOException {
        OkCoinFuturesUserInfoFixed okCoinFuturesUserInfoFixed = this.okCoin.getFuturesUserInfoFixed(this.apikey, this.signatureCreator());
        return OkCoinAccountServiceRaw.returnOrThrow(okCoinFuturesUserInfoFixed);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OKCoinWithdraw withdraw(String currencySymbol, String withdrawAddress, BigDecimal amount, String target) throws IOException {
        String fee = null;
        if (target.equals("address")) {
            if (currencySymbol.startsWith("btc")) {
                fee = "0.002";
                return this.withdraw(currencySymbol, withdrawAddress, amount, target, fee);
            } else if (currencySymbol.startsWith("ltc")) {
                fee = "0.001";
                return this.withdraw(currencySymbol, withdrawAddress, amount, target, fee);
            } else {
                if (!currencySymbol.startsWith("eth")) throw new IllegalArgumentException("Unsupported withdraw currency");
                fee = "0.01";
            }
            return this.withdraw(currencySymbol, withdrawAddress, amount, target, fee);
        } else {
            if (!target.equals("okex") && !target.equals("okcn") && !target.equals("okcom")) throw new IllegalArgumentException("Unsupported withdraw target");
            fee = "0";
        }
        return this.withdraw(currencySymbol, withdrawAddress, amount, target, fee);
    }

    public OKCoinWithdraw withdraw(String currencySymbol, String withdrawAddress, BigDecimal amount, String target, String fee) throws IOException {
        if (this.tradepwd == null) {
            throw new ExchangeException("You need to provide the 'trade/admin password' using exchange.getExchangeSpecification().setExchangeSpecificParametersItem(\"tradepwd\", \"SECRET\");");
        }
        OKCoinWithdraw withdrawResult = this.okCoin.withdraw(this.exchange.getExchangeSpecification().getApiKey(), currencySymbol, this.signatureCreator(), fee, this.tradepwd, withdrawAddress, amount.toString(), target);
        return OkCoinAccountServiceRaw.returnOrThrow(withdrawResult);
    }

    public OkCoinAccountRecords getAccountRecords(String symbol, String type, String currentPage, String pageLength) throws IOException {
        OkCoinAccountRecords accountRecords = this.okCoin.getAccountRecords(this.apikey, symbol, type, currentPage, pageLength, this.signatureCreator());
        return OkCoinAccountServiceRaw.returnOrThrow(accountRecords);
    }

    public boolean moveFunds(String symbol, BigDecimal amount, AccountType from, AccountType to) throws IOException {
        return this.okCoin.fundsTransfer(this.apikey, symbol, amount.toPlainString(), from.getValue(), to.getValue(), this.signatureCreator()).isResult();
    }

    public static enum AccountType {
        SPOT(1),
        FUTURES(3),
        MY_WALLET(6);

        private final int value;

        private AccountType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

