/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.service.OkCoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class OkCoinFuturesMarketDataService
extends OkCoinMarketDataServiceRaw
implements MarketDataService {
    private final FuturesContract futuresContract;

    public OkCoinFuturesMarketDataService(Exchange exchange, FuturesContract futuresContract) {
        super(exchange);
        this.futuresContract = futuresContract;
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (args != null && args.length > 0) {
            return OkCoinAdapters.adaptTicker(this.getFuturesTicker(currencyPair, (FuturesContract)((Object)args[0])), currencyPair);
        }
        return OkCoinAdapters.adaptTicker(this.getFuturesTicker(currencyPair, this.futuresContract), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (args != null && args.length > 0) {
            return OkCoinAdapters.adaptOrderBook(this.getFuturesDepth(currencyPair, (FuturesContract)((Object)args[0])), currencyPair);
        }
        return OkCoinAdapters.adaptOrderBook(this.getFuturesDepth(currencyPair, this.futuresContract), currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (args != null && args.length > 0) {
            return OkCoinAdapters.adaptTrades(this.getFuturesTrades(currencyPair, (FuturesContract)((Object)args[0])), currencyPair);
        }
        return OkCoinAdapters.adaptTrades(this.getFuturesTrades(currencyPair, this.futuresContract), currencyPair);
    }
}

