/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.OkCoin;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinDepth;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinFutureComment;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinFutureHoldAmount;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinFutureKline;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinKline;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinKlineType;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinTickerResponse;
import org.knowm.xchange.okcoin.dto.marketdata.OkCoinTrade;
import org.knowm.xchange.okcoin.service.OkCoinBaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class OkCoinMarketDataServiceRaw
extends OkCoinBaseService {
    private final OkCoin okCoin;

    public OkCoinMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.okCoin = (OkCoin)RestProxyFactory.createProxy(OkCoin.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
    }

    public OkCoinTickerResponse getTicker(CurrencyPair currencyPair) throws IOException {
        return this.okCoin.getTicker("1", OkCoinAdapters.adaptSymbol(currencyPair));
    }

    public OkCoinTickerResponse getFuturesTicker(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesTicker(OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName());
    }

    public OkCoinDepth getDepth(CurrencyPair currencyPair) throws IOException {
        return this.getDepth(currencyPair, null);
    }

    public OkCoinDepth getDepth(CurrencyPair currencyPair, Integer size) throws IOException {
        size = size == null || size < 1 || size > 200 ? 200 : size;
        return this.okCoin.getDepth("1", OkCoinAdapters.adaptSymbol(currencyPair), size);
    }

    public OkCoinDepth getFuturesDepth(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesDepth("1", OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName().toLowerCase());
    }

    public OkCoinTrade[] getTrades(CurrencyPair currencyPair) throws IOException {
        return this.getTrades(currencyPair, null);
    }

    public OkCoinTrade[] getTrades(CurrencyPair currencyPair, Long since) throws IOException {
        return this.okCoin.getTrades("1", OkCoinAdapters.adaptSymbol(currencyPair), since);
    }

    public OkCoinTrade[] getFuturesTrades(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesTrades("1", OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName().toLowerCase());
    }

    public OkCoinFutureComment getFuturesIndex(CurrencyPair currencyPair) throws IOException {
        return this.okCoin.getFuturesIndex("1", OkCoinAdapters.adaptSymbol(currencyPair));
    }

    public OkCoinFutureComment getFuturesIndex(String symbol) throws IOException {
        return this.okCoin.getFuturesIndex("1", symbol);
    }

    public OkCoinFutureComment getExchangRate_US_CH() throws IOException {
        return this.okCoin.getExchangRate_US_CH();
    }

    public OkCoinFutureComment getFutureEstimatedPrice(CurrencyPair currencyPair) throws IOException {
        return this.okCoin.getFutureEstimatedPrice("1", OkCoinAdapters.adaptSymbol(currencyPair));
    }

    public List<OkCoinFutureKline> getFutureKline(CurrencyPair currencyPair, OkCoinKlineType type, FuturesContract contractType, Integer size, Long since) throws IOException {
        List<Object[]> list = this.okCoin.getFutureKline("1", OkCoinAdapters.adaptSymbol(currencyPair), type.getType(), contractType.getName(), size, since);
        ArrayList<OkCoinFutureKline> klineList = new ArrayList<OkCoinFutureKline>();
        list.stream().forEach(kline -> klineList.add(new OkCoinFutureKline((Object[])kline)));
        return klineList;
    }

    public List<OkCoinFutureKline> getFutureKline(CurrencyPair currencyPair, OkCoinKlineType type, FuturesContract contractType) throws IOException {
        return this.getFutureKline(currencyPair, type, contractType, 0, 0L);
    }

    public List<OkCoinFutureKline> getFutureKline(CurrencyPair currencyPair, OkCoinKlineType type, FuturesContract contractType, Integer size) throws IOException {
        return this.getFutureKline(currencyPair, type, contractType, size, 0L);
    }

    public List<OkCoinFutureKline> getFutureKline(CurrencyPair currencyPair, OkCoinKlineType type, FuturesContract contractType, Long since) throws IOException {
        return this.getFutureKline(currencyPair, type, contractType, 0, since);
    }

    public OkCoinFutureHoldAmount[] getFutureHoldAmount(CurrencyPair currencyPair, FuturesContract contractType) throws IOException {
        return this.okCoin.getFutureHoldAmount("1", OkCoinAdapters.adaptSymbol(currencyPair), contractType.getName());
    }

    public OkCoinFutureComment getFuturePriceLimit(CurrencyPair currencyPair, FuturesContract contractType) throws IOException {
        return this.okCoin.getFuturePriceLimit("1", OkCoinAdapters.adaptSymbol(currencyPair), contractType.getName());
    }

    public List<OkCoinKline> getKlines(CurrencyPair currencyPair, OkCoinKlineType type) throws IOException {
        return this.getKlines(currencyPair, type, null, null);
    }

    public List<OkCoinKline> getKlines(CurrencyPair currencyPair, OkCoinKlineType type, Integer size) throws IOException {
        return this.getKlines(currencyPair, type, size, null);
    }

    public List<OkCoinKline> getKlines(CurrencyPair currencyPair, OkCoinKlineType type, Long timestamp) throws IOException {
        return this.getKlines(currencyPair, type, null, timestamp);
    }

    public List<OkCoinKline> getKlines(CurrencyPair currencyPair, OkCoinKlineType type, Integer size, Long timestamp) throws IOException {
        ArrayList<OkCoinKline> klineList = new ArrayList<OkCoinKline>();
        List<Object[]> list = this.okCoin.getKlines(OkCoinAdapters.adaptSymbol(currencyPair), type.getType(), size, timestamp);
        list.stream().forEach(kline -> klineList.add(new OkCoinKline((Object[])kline)));
        return klineList;
    }
}

