/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.dto.trade.OkCoinOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinTradeResult;
import org.knowm.xchange.okcoin.dto.trade.result.OkCoinBatchTradeResult;
import org.knowm.xchange.okcoin.dto.trade.result.OkCoinMoreTradeResult;
import org.knowm.xchange.okcoin.service.OkCoinTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class OkCoinTradeService
extends OkCoinTradeServiceRaw
implements TradeService {
    private static final String ORDER_STATUS_FILLED = "1";
    private static final OpenOrders NO_OPEN_ORDERS = new OpenOrders(Collections.emptyList());

    public OkCoinTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) {
        OkCoinOrderResult orderResults;
        if (!(params instanceof OpenOrdersParamCurrencyPair)) {
            throw new UnsupportedOperationException("Getting open orders is only available for a single market.");
        }
        CurrencyPair symbol = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
        try {
            orderResults = this.getOrder(-1L, OkCoinAdapters.adaptSymbol(symbol));
        }
        catch (Exception e) {
            return NO_OPEN_ORDERS;
        }
        if (orderResults.getOrders() == null || orderResults.getOrders().length == 0) {
            return NO_OPEN_ORDERS;
        }
        return OkCoinAdapters.adaptOpenOrders(Collections.singletonList(orderResults));
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        String marketOrderType = null;
        String price = null;
        String amount = null;
        long orderId = -1L;
        String symbol = OkCoinAdapters.adaptSymbol(marketOrder.getCurrencyPair());
        if (marketOrder.getType().equals((Object)Order.OrderType.BID)) {
            marketOrderType = "buy_market";
            price = marketOrder.getOriginalAmount().toPlainString();
            orderId = this.placeMarketOrderBuy(symbol, marketOrderType, price).getOrderId();
        } else {
            marketOrderType = "sell_market";
            amount = marketOrder.getOriginalAmount().toPlainString();
            orderId = this.placeMarketOrderSell(symbol, marketOrderType, amount).getOrderId();
        }
        return String.valueOf(orderId);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        long orderId = this.trade(OkCoinAdapters.adaptSymbol(limitOrder.getCurrencyPair()), limitOrder.getType() == Order.OrderType.BID ? "buy" : "sell", limitOrder.getLimitPrice().toPlainString(), limitOrder.getOriginalAmount().toPlainString()).getOrderId();
        return String.valueOf(orderId);
    }

    public String placeBatchLimitOrder(LimitOrder ... limitOrders) throws IOException {
        if (limitOrders == null || limitOrders.length < 1) {
            throw new RuntimeException("this limitOrders not be null or length min 1");
        }
        if (limitOrders.length > 5) {
            throw new RuntimeException("this limitOrders length max 5");
        }
        ArrayList list = new ArrayList();
        Arrays.stream(limitOrders).forEach(limitOrder -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("price", limitOrder.getLimitPrice().toPlainString());
            map.put("amount", limitOrder.getOriginalAmount().toPlainString());
            map.put("type", limitOrder.getType() == Order.OrderType.BID ? "buy" : "sell");
            list.add(map);
        });
        ObjectMapper mapper = new ObjectMapper();
        String ordersData = mapper.writeValueAsString(list);
        OkCoinMoreTradeResult result = this.batchTrade(OkCoinAdapters.adaptSymbol(limitOrders[0].getCurrencyPair()), limitOrders[0].getType() == Order.OrderType.BID ? "buy" : "sell", ordersData);
        StringBuilder builder = new StringBuilder();
        if (result.isStatus()) {
            result.getOrderInfo().stream().forEach(p -> {
                if (-1L != Long.valueOf((Long)p.get("order_id"))) {
                    builder.append(",").append((String)p.get("order_id"));
                }
            });
        }
        if (builder.length() > 1) {
            return builder.substring(1);
        }
        return "no one order success";
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        String symbol;
        OkCoinTradeResult cancelResult;
        if (!(orderParams instanceof CancelOrderByIdParams) || !(orderParams instanceof CancelOrderByCurrencyPair)) {
            throw new UnsupportedOperationException("Cancelling an order is only available for a single market and a single id.");
        }
        long id = Long.valueOf(((CancelOrderByIdParams)orderParams).getOrderId());
        return id == (cancelResult = this.cancelOrder(id, symbol = OkCoinAdapters.adaptSymbol(((CancelOrderByCurrencyPair)orderParams).getCurrencyPair()))).getOrderId();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public Map<LimitOrder, Boolean> cancelUpToThreeOrders(List<LimitOrder> limitOrders) throws IOException {
        Set<Long> ordersToCancel = limitOrders.stream().map(Order::getId).map(Long::parseLong).collect(Collectors.toSet());
        if (ordersToCancel.isEmpty() || ordersToCancel.size() > 3) {
            throw new UnsupportedOperationException("Can only batch cancel 1 to 3 orders. " + ordersToCancel.size() + " orders provided.");
        }
        CurrencyPair currencyPair = limitOrders.get(0).getCurrencyPair();
        boolean valid = limitOrders.stream().allMatch(order -> order.getCurrencyPair().equals((Object)currencyPair));
        if (!valid) {
            throw new UnsupportedOperationException("Can only batch cancel orders with the same currency pair.");
        }
        OkCoinBatchTradeResult okCoinBatchTradeResult = this.cancelUpToThreeOrders(ordersToCancel, OkCoinAdapters.adaptSymbol(currencyPair));
        HashMap<String, Boolean> requestResults = new HashMap<String, Boolean>(ordersToCancel.size());
        if (okCoinBatchTradeResult.getSuccess() != null) {
            Arrays.stream(okCoinBatchTradeResult.getSuccess().split(",")).forEach(id -> requestResults.put((String)id, Boolean.TRUE));
        }
        if (okCoinBatchTradeResult.getError() != null) {
            Arrays.stream(okCoinBatchTradeResult.getError().split(",")).forEach(id -> requestResults.put((String)id, Boolean.FALSE));
        }
        HashMap<LimitOrder, Boolean> results = new HashMap<LimitOrder, Boolean>(limitOrders.size());
        requestResults.forEach((id, result) -> limitOrders.stream().filter(order -> order.getId().equals(id)).findAny().ifPresent(limitOrder -> results.put((LimitOrder)limitOrder, (Boolean)requestResults.get(id))));
        return results;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Integer pageLength = null;
        Integer pageNumber = null;
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging paging = (TradeHistoryParamPaging)params;
            pageLength = paging.getPageLength();
            pageNumber = paging.getPageNumber();
        }
        if (pageNumber == null) {
            pageNumber = 1;
        }
        if (pageLength == null) {
            pageLength = 200;
        }
        CurrencyPair pair = null;
        if (params instanceof TradeHistoryParamCurrencyPair) {
            pair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
        }
        if (pair == null) {
            pair = this.useIntl ? CurrencyPair.BTC_USD : CurrencyPair.BTC_CNY;
        }
        OkCoinOrderResult orderHistory = this.getOrderHistory(OkCoinAdapters.adaptSymbol(pair), ORDER_STATUS_FILLED, pageNumber.toString(), pageLength.toString());
        return OkCoinAdapters.adaptTrades(orderHistory);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new OkCoinTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    @Override
    public OkCoinOrderResult getOrder(String symbol) throws IOException {
        return super.getOrder(symbol);
    }

    @Override
    public OkCoinOrderResult getOrder(long orderId, String symbol) throws IOException {
        return super.getOrder(orderId, symbol);
    }

    public OkCoinOrderResult getOrder(String symbol, Integer type, String ... orderIds) throws IOException {
        if (orderIds == null || orderIds.length > 50) {
            throw new UnsupportedOperationException("Can only get 1 to 50 orders. " + orderIds.length + " orders provided.");
        }
        String ids = Arrays.stream(orderIds).collect(Collectors.joining(","));
        return super.getOrder(symbol, type, ids);
    }

    public static class OkCoinCancelOrderParam
    implements CancelOrderByIdParams,
    CancelOrderByCurrencyPair {
        private final CurrencyPair currencyPair;
        private final String id;

        public OkCoinCancelOrderParam(CurrencyPair currencyPair, String id) {
            this.currencyPair = currencyPair;
            this.id = id;
        }

        public CurrencyPair getCurrencyPair() {
            return this.currencyPair;
        }

        public String getOrderId() {
            return this.id;
        }
    }

    public static class OkCoinTradeHistoryParams
    extends DefaultTradeHistoryParamPaging
    implements TradeHistoryParamCurrencyPair {
        private CurrencyPair pair;

        public OkCoinTradeHistoryParams() {
        }

        public OkCoinTradeHistoryParams(Integer pageLength, Integer pageNumber, CurrencyPair pair) {
            super(pageLength, pageNumber);
            this.pair = pair;
        }

        public CurrencyPair getCurrencyPair() {
            return this.pair;
        }

        public void setCurrencyPair(CurrencyPair pair) {
            this.pair = pair;
        }
    }
}

