/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.service;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.okcoin.FuturesContract;
import org.knowm.xchange.okcoin.OkCoinAdapters;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinFuturesTradeHistoryResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinOrderResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinPositionResult;
import org.knowm.xchange.okcoin.dto.trade.OkCoinPriceLimit;
import org.knowm.xchange.okcoin.dto.trade.OkCoinTradeResult;
import org.knowm.xchange.okcoin.dto.trade.result.OkCoinBatchTradeResult;
import org.knowm.xchange.okcoin.dto.trade.result.OkCoinFutureExplosiveResult;
import org.knowm.xchange.okcoin.dto.trade.result.OkCoinMoreTradeResult;
import org.knowm.xchange.okcoin.service.OKCoinBaseTradeService;

public class OkCoinTradeServiceRaw
extends OKCoinBaseTradeService {
    protected static final String BATCH_DELIMITER = ",";

    protected OkCoinTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public OkCoinTradeResult trade(String symbol, String type, String price, String amount) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.trade(this.apikey, symbol, type, price, amount, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinTradeResult placeMarketOrderBuy(String symbol, String type, String price) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.placeMarketOrderBuy(this.apikey, symbol, type, price, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinTradeResult placeMarketOrderSell(String symbol, String type, String amount) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.placeMarketOrderSell(this.apikey, symbol, type, amount, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinMoreTradeResult batchTrade(String symbol, String type, String ordersData) throws IOException {
        OkCoinMoreTradeResult tradeResult = this.okCoin.batchTrade(this.apikey, symbol, type, ordersData, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinTradeResult cancelOrder(long orderId, String symbol) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.cancelOrder(this.apikey, orderId, symbol, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinBatchTradeResult cancelUpToThreeOrders(Set<Long> orderIds, String symbol) throws IOException {
        String ids = orderIds.stream().map(Object::toString).collect(Collectors.joining(BATCH_DELIMITER));
        return this.okCoin.cancelOrders(this.apikey, ids, symbol, this.signatureCreator());
    }

    public OkCoinOrderResult getOrder(String symbol) throws IOException {
        return this.getOrder(-1L, symbol);
    }

    public OkCoinOrderResult getOrder(long orderId, String symbol) throws IOException {
        OkCoinOrderResult orderResult = this.okCoin.getOrder(this.apikey, orderId, symbol, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(orderResult);
    }

    public OkCoinOrderResult getOrder(String symbol, Integer type, String orderIds) throws IOException {
        OkCoinOrderResult orderResult = this.okCoin.getOrders(this.apikey, type, orderIds, symbol, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(orderResult);
    }

    public OkCoinOrderResult getOrderHistory(String symbol, String status, String currentPage, String pageLength) throws IOException {
        OkCoinOrderResult orderResult = this.okCoin.getOrderHistory(this.apikey, symbol, status, currentPage, pageLength, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(orderResult);
    }

    public OkCoinTradeResult futuresTrade(String symbol, String type, String price, String amount, FuturesContract contract, int matchPrice, int leverRate) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.futuresTrade(this.apikey, symbol, contract.getName(), type, price, amount, matchPrice, leverRate, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinTradeResult futuresCancelOrder(long orderId, String symbol, FuturesContract contract) throws IOException {
        OkCoinTradeResult tradeResult = this.okCoin.futuresCancelOrder(this.apikey, String.valueOf(orderId), symbol, contract.getName(), this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(tradeResult);
    }

    public OkCoinFuturesOrderResult getFuturesOrder(long orderId, String symbol, String currentPage, String pageLength, FuturesContract contract) throws IOException {
        OkCoinFuturesOrderResult futuresOrder = this.okCoin.getFuturesOrder(this.apikey, orderId, symbol, "1", currentPage, pageLength, contract.getName(), this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(futuresOrder);
    }

    public OkCoinPriceLimit getFuturesPriceLimits(CurrencyPair currencyPair, FuturesContract prompt) throws IOException {
        return this.okCoin.getFuturesPriceLimits(OkCoinAdapters.adaptSymbol(currencyPair), prompt.getName());
    }

    public OkCoinFuturesOrderResult getFuturesFilledOrder(long orderId, String symbol, String currentPage, String pageLength, FuturesContract contract) throws IOException {
        OkCoinFuturesOrderResult futuresOrder = this.okCoin.getFuturesOrder(this.apikey, orderId, symbol, "2", currentPage, pageLength, contract.getName(), this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(futuresOrder);
    }

    public OkCoinFuturesOrderResult getFuturesOrders(String orderIds, String symbol, FuturesContract contract) throws IOException {
        OkCoinFuturesOrderResult futuresOrder = this.okCoin.getFuturesOrders(this.apikey, orderIds, symbol, contract.getName(), this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(futuresOrder);
    }

    public OkCoinFuturesTradeHistoryResult[] getFuturesTradesHistory(String symbol, long since, String date) throws IOException {
        OkCoinFuturesTradeHistoryResult[] futuresHistory = this.okCoin.getFuturesTradeHistory(this.apikey, since, symbol, date, this.signatureCreator());
        return futuresHistory;
    }

    public OkCoinPositionResult getFuturesPosition(String symbol, FuturesContract contract) throws IOException {
        OkCoinPositionResult futuresPositionsCross = this.okCoin.getFuturesPositionsCross(this.apikey, symbol, contract.getName(), this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(futuresPositionsCross);
    }

    public OkCoinPositionResult getFuturesPosition(String symbol, String contract) throws IOException {
        OkCoinPositionResult futuresPositionsCross = this.okCoin.getFuturesPositionsCross(this.apikey, symbol, contract, this.signatureCreator());
        return OkCoinTradeServiceRaw.returnOrThrow(futuresPositionsCross);
    }

    public OkCoinMoreTradeResult futureBatchTrade(String symbol, String contractType, String ordersData, String leverRate) throws IOException {
        return this.okCoin.futureBatchTrade(this.apikey, symbol, contractType, ordersData, this.signatureCreator(), leverRate);
    }

    public OkCoinPositionResult getFuturesPositionsFixed(CurrencyPair currencyPair, FuturesContract contract) throws IOException {
        return this.okCoin.getFuturesPositionsFixed(this.apikey, OkCoinAdapters.adaptSymbol(currencyPair), contract.getName(), this.signatureCreator());
    }

    public OkCoinFutureExplosiveResult futureExplosive(CurrencyPair pair, FuturesContract type, String status, Integer currentPage, Integer pageNumber, Integer pageLength) {
        return this.okCoin.futureExplosive(this.apikey, OkCoinAdapters.adaptSymbol(pair), type.getName(), status, this.signatureCreator(), currentPage, pageNumber, pageLength);
    }
}

