/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.v3.dto.account;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OkexWithdrawalRequest {
    private String currency;
    private BigDecimal amount;
    private String destination;
    @JsonProperty(value="to_address")
    private String toAddress;
    @JsonProperty(value="trade_pwd")
    private String tradePwd;
    private BigDecimal fee;

    OkexWithdrawalRequest(String currency, BigDecimal amount, String destination, String toAddress, String tradePwd, BigDecimal fee) {
        this.currency = currency;
        this.amount = amount;
        this.destination = destination;
        this.toAddress = toAddress;
        this.tradePwd = tradePwd;
        this.fee = fee;
    }

    public static OkexWithdrawalRequestBuilder builder() {
        return new OkexWithdrawalRequestBuilder();
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getTradePwd() {
        return this.tradePwd;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @JsonProperty(value="to_address")
    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    @JsonProperty(value="trade_pwd")
    public void setTradePwd(String tradePwd) {
        this.tradePwd = tradePwd;
    }

    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkexWithdrawalRequest)) {
            return false;
        }
        OkexWithdrawalRequest other = (OkexWithdrawalRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$toAddress = this.getToAddress();
        String other$toAddress = other.getToAddress();
        if (this$toAddress == null ? other$toAddress != null : !this$toAddress.equals(other$toAddress)) {
            return false;
        }
        String this$tradePwd = this.getTradePwd();
        String other$tradePwd = other.getTradePwd();
        if (this$tradePwd == null ? other$tradePwd != null : !this$tradePwd.equals(other$tradePwd)) {
            return false;
        }
        BigDecimal this$fee = this.getFee();
        BigDecimal other$fee = other.getFee();
        return !(this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OkexWithdrawalRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $toAddress = this.getToAddress();
        result = result * 59 + ($toAddress == null ? 43 : $toAddress.hashCode());
        String $tradePwd = this.getTradePwd();
        result = result * 59 + ($tradePwd == null ? 43 : $tradePwd.hashCode());
        BigDecimal $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        return result;
    }

    public String toString() {
        return "OkexWithdrawalRequest(currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", destination=" + this.getDestination() + ", toAddress=" + this.getToAddress() + ", tradePwd=" + this.getTradePwd() + ", fee=" + this.getFee() + ")";
    }

    public static class OkexWithdrawalRequestBuilder {
        private String currency;
        private BigDecimal amount;
        private String destination;
        private String toAddress;
        private String tradePwd;
        private BigDecimal fee;

        OkexWithdrawalRequestBuilder() {
        }

        public OkexWithdrawalRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public OkexWithdrawalRequestBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public OkexWithdrawalRequestBuilder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @JsonProperty(value="to_address")
        public OkexWithdrawalRequestBuilder toAddress(String toAddress) {
            this.toAddress = toAddress;
            return this;
        }

        @JsonProperty(value="trade_pwd")
        public OkexWithdrawalRequestBuilder tradePwd(String tradePwd) {
            this.tradePwd = tradePwd;
            return this;
        }

        public OkexWithdrawalRequestBuilder fee(BigDecimal fee) {
            this.fee = fee;
            return this;
        }

        public OkexWithdrawalRequest build() {
            return new OkexWithdrawalRequest(this.currency, this.amount, this.destination, this.toAddress, this.tradePwd, this.fee);
        }

        public String toString() {
            return "OkexWithdrawalRequest.OkexWithdrawalRequestBuilder(currency=" + this.currency + ", amount=" + this.amount + ", destination=" + this.destination + ", toAddress=" + this.toAddress + ", tradePwd=" + this.tradePwd + ", fee=" + this.fee + ")";
        }
    }
}

