/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.v3.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FundsTransferRequest {
    private String currency;
    private BigDecimal amount;
    private String from;
    private String to;
    @JsonProperty(value="sub_account")
    private String subAccount;
    @JsonProperty(value="instrument_id")
    private String instrumentId;

    FundsTransferRequest(String currency, BigDecimal amount, String from, String to, String subAccount, String instrumentId) {
        this.currency = currency;
        this.amount = amount;
        this.from = from;
        this.to = to;
        this.subAccount = subAccount;
        this.instrumentId = instrumentId;
    }

    public static FundsTransferRequestBuilder builder() {
        return new FundsTransferRequestBuilder();
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSubAccount() {
        return this.subAccount;
    }

    public String getInstrumentId() {
        return this.instrumentId;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @JsonProperty(value="sub_account")
    public void setSubAccount(String subAccount) {
        this.subAccount = subAccount;
    }

    @JsonProperty(value="instrument_id")
    public void setInstrumentId(String instrumentId) {
        this.instrumentId = instrumentId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FundsTransferRequest)) {
            return false;
        }
        FundsTransferRequest other = (FundsTransferRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$subAccount = this.getSubAccount();
        String other$subAccount = other.getSubAccount();
        if (this$subAccount == null ? other$subAccount != null : !this$subAccount.equals(other$subAccount)) {
            return false;
        }
        String this$instrumentId = this.getInstrumentId();
        String other$instrumentId = other.getInstrumentId();
        return !(this$instrumentId == null ? other$instrumentId != null : !this$instrumentId.equals(other$instrumentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FundsTransferRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $subAccount = this.getSubAccount();
        result = result * 59 + ($subAccount == null ? 43 : $subAccount.hashCode());
        String $instrumentId = this.getInstrumentId();
        result = result * 59 + ($instrumentId == null ? 43 : $instrumentId.hashCode());
        return result;
    }

    public String toString() {
        return "FundsTransferRequest(currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", subAccount=" + this.getSubAccount() + ", instrumentId=" + this.getInstrumentId() + ")";
    }

    public static class FundsTransferRequestBuilder {
        private String currency;
        private BigDecimal amount;
        private String from;
        private String to;
        private String subAccount;
        private String instrumentId;

        FundsTransferRequestBuilder() {
        }

        public FundsTransferRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public FundsTransferRequestBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public FundsTransferRequestBuilder from(String from) {
            this.from = from;
            return this;
        }

        public FundsTransferRequestBuilder to(String to) {
            this.to = to;
            return this;
        }

        @JsonProperty(value="sub_account")
        public FundsTransferRequestBuilder subAccount(String subAccount) {
            this.subAccount = subAccount;
            return this;
        }

        @JsonProperty(value="instrument_id")
        public FundsTransferRequestBuilder instrumentId(String instrumentId) {
            this.instrumentId = instrumentId;
            return this;
        }

        public FundsTransferRequest build() {
            return new FundsTransferRequest(this.currency, this.amount, this.from, this.to, this.subAccount, this.instrumentId);
        }

        public String toString() {
            return "FundsTransferRequest.FundsTransferRequestBuilder(currency=" + this.currency + ", amount=" + this.amount + ", from=" + this.from + ", to=" + this.to + ", subAccount=" + this.subAccount + ", instrumentId=" + this.instrumentId + ")";
        }
    }
}

