/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.v3.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.okcoin.OkexExchangeV3;
import org.knowm.xchange.okcoin.v3.dto.account.FuturesPosition;
import org.knowm.xchange.okcoin.v3.dto.account.MarginAccountResponse;
import org.knowm.xchange.okcoin.v3.dto.account.MarginAccountSettingsRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexDepositRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexFundingAccountRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexSpotAccountRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalRecord;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalRequest;
import org.knowm.xchange.okcoin.v3.dto.account.OkexWithdrawalResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FundsTransferRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.FundsTransferResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesAccountsByCurrencyResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesAccountsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesPositionsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginBorrowRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginBorrowResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginRepaymentRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.MarginRepaymentResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapAccountsResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapPositionsEntry;
import org.knowm.xchange.okcoin.v3.service.OkexBaseService;
import si.mazi.rescu.ParamsDigest;

public class OkexAccountServiceRaw
extends OkexBaseService {
    protected OkexAccountServiceRaw(OkexExchangeV3 exchange) {
        super(exchange);
    }

    public List<OkexFundingAccountRecord> fundingAccountInformation() throws IOException {
        return this.okex.fundingAccountInformation(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public List<OkexSpotAccountRecord> spotTradingAccount() throws IOException {
        return this.okex.spotTradingAccount(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public FundsTransferResponse fundsTransfer(String currency, BigDecimal amount, String from, String to, String subAccount, String instrumentId) throws IOException {
        FundsTransferRequest req = FundsTransferRequest.builder().currency(currency).amount(amount).from(from).to(to).subAccount(subAccount).instrumentId(instrumentId).build();
        FundsTransferResponse res = this.okex.fundsTransfer(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public OkexWithdrawalResponse withdrawal(OkexWithdrawalRequest req) throws IOException {
        OkexWithdrawalResponse res = this.okex.withdrawal(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public List<OkexWithdrawalRecord> recentWithdrawalHistory() throws IOException {
        return this.okex.recentWithdrawalHistory(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public List<OkexDepositRecord> recentDepositHistory() throws IOException {
        return this.okex.recentDepositHistory(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public List<FuturesPosition> getFuturesPositions() throws IOException {
        FuturesPositionsResponse res = this.okex.getFuturesPositions(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
        res.checkResult();
        return res.getHolding().get(0);
    }

    public FuturesAccountsResponse getFuturesAccounts() throws IOException {
        FuturesAccountsResponse res = this.okex.getFuturesAccounts(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
        res.checkResult();
        return res;
    }

    public FuturesAccountsByCurrencyResponse getFuturesAccounts(String currency) throws IOException {
        FuturesAccountsByCurrencyResponse res = this.okex.getFuturesAccounts(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase, currency);
        res.checkResult();
        return res;
    }

    public List<SwapPositionsEntry> getSwapPositions() throws IOException {
        return this.okex.getSwapPositions(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public List<SwapAccountsResponse.SwapAccountInfo> getSwapAccounts() throws IOException {
        SwapAccountsResponse res = this.okex.getSwapAccounts(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
        res.checkResult();
        return res.getInfo();
    }

    public MarginAccountResponse[] marginAccounts() throws IOException {
        return this.okex.marginAccounts(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public List<MarginAccountSettingsRecord> marginAccountsSettings() throws IOException {
        return this.okex.marginAccountsSettings(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase);
    }

    public MarginBorrowResponse marginBorrow(MarginBorrowRequest req) throws IOException {
        return this.okex.marginBorrow(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase, req);
    }

    public MarginRepaymentResponse marginRepayment(MarginRepaymentRequest req) throws IOException {
        return this.okex.marginRepayment(this.apikey, (ParamsDigest)this.digest, OkexAccountServiceRaw.timestamp(), this.passphrase, req);
    }
}

