/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.v3.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.okcoin.OkexDigestV3;
import org.knowm.xchange.okcoin.OkexExchangeV3;
import org.knowm.xchange.okcoin.OkexV3;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class OkexBaseService
extends BaseExchangeService<OkexExchangeV3>
implements BaseService {
    protected final OkexV3 okex;
    protected final String apikey;
    protected final String passphrase;
    protected final OkexDigestV3 digest;
    protected final String tradepwd;

    public OkexBaseService(OkexExchangeV3 exchange) {
        super((Exchange)exchange);
        ExchangeSpecification spec = exchange.getExchangeSpecification();
        this.okex = (OkexV3)RestProxyFactory.createProxy(OkexV3.class, (String)spec.getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.apikey = spec.getApiKey();
        this.passphrase = (String)spec.getExchangeSpecificParametersItem("passphrase");
        String secretKey = spec.getSecretKey();
        this.digest = secretKey == null ? null : new OkexDigestV3(secretKey);
        this.tradepwd = (String)spec.getExchangeSpecificParametersItem("tradepwd");
    }

    protected static String timestamp() {
        return System.currentTimeMillis() / 1000L + ".000";
    }
}

