/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.v3.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.okcoin.OkexAdaptersV3;
import org.knowm.xchange.okcoin.OkexExchangeV3;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexOpenOrder;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexOrderFlags;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexTradeHistoryParams;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderPlacementResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderPlacementType;
import org.knowm.xchange.okcoin.v3.dto.trade.Side;
import org.knowm.xchange.okcoin.v3.dto.trade.SpotOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.service.OkexTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class OkexTradeService
extends OkexTradeServiceRaw
implements TradeService {
    private static final int orders_limit = 100;
    private static final int transactions_limit = 100;

    public OkexTradeService(OkexExchangeV3 exchange) {
        super(exchange);
    }

    public String placeLimitOrder(LimitOrder o) throws IOException {
        OrderPlacementType orderType = o.hasFlag((Order.IOrderFlags)OkexOrderFlags.POST_ONLY) ? OrderPlacementType.post_only : OrderPlacementType.normal;
        SpotOrderPlacementRequest req = SpotOrderPlacementRequest.builder().instrumentId(OkexAdaptersV3.toSpotInstrument(o.getCurrencyPair())).price(o.getLimitPrice()).size(o.getOriginalAmount()).side(o.getType() == Order.OrderType.ASK ? Side.sell : Side.buy).orderType(orderType).build();
        OrderPlacementResponse placed = this.spotPlaceOrder(req);
        return placed.getOrderId();
    }

    public String placeMarginLimitOrder(LimitOrder o) throws IOException {
        OrderPlacementType orderType = o.hasFlag((Order.IOrderFlags)OkexOrderFlags.POST_ONLY) ? OrderPlacementType.post_only : OrderPlacementType.normal;
        SpotOrderPlacementRequest req = SpotOrderPlacementRequest.builder().instrumentId(OkexAdaptersV3.toSpotInstrument(o.getCurrencyPair())).price(o.getLimitPrice()).size(o.getOriginalAmount()).side(o.getType() == Order.OrderType.ASK ? Side.sell : Side.buy).orderType(orderType).build();
        OrderPlacementResponse placed = this.marginPlaceOrder(req);
        return placed.getOrderId();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (!(orderParams instanceof CancelOrderByIdParams) || !(orderParams instanceof CancelOrderByCurrencyPair)) {
            throw new UnsupportedOperationException("Cancelling an order is only available for a single market and a single id.");
        }
        String id = ((CancelOrderByIdParams)orderParams).getOrderId();
        String instrumentId = OkexAdaptersV3.toSpotInstrument(((CancelOrderByCurrencyPair)orderParams).getCurrencyPair());
        OrderCancellationRequest req = OrderCancellationRequest.builder().instrumentId(instrumentId).build();
        OrderCancellationResponse o = this.spotCancelOrder(id, req);
        return true;
    }

    public OpenOrders getOpenOrders() throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        if (!(params instanceof OpenOrdersParamCurrencyPair)) {
            throw new UnsupportedOperationException("Getting open orders is only available for a single market.");
        }
        CurrencyPair pair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
        String instrument = OkexAdaptersV3.toSpotInstrument(pair);
        String state = "6";
        String from = null;
        ArrayList<OkexOpenOrder> all = new ArrayList<OkexOpenOrder>();
        boolean stop = false;
        do {
            List<OkexOpenOrder> l = this.getSpotOrderList(instrument, from, null, 100, "6");
            all.addAll(l);
            boolean bl = stop = l.size() < 100;
            if (stop) continue;
            from = l.get(l.size() - 1).getOrderId();
        } while (!stop);
        return new OpenOrders(all.stream().map(OkexAdaptersV3::convert).collect(Collectors.toList()));
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new OkexTradeHistoryParams();
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        if (!(params instanceof TradeHistoryParamCurrencyPair)) {
            throw new UnsupportedOperationException("Getting open orders is only available for a single market.");
        }
        String instrument = OkexAdaptersV3.toSpotInstrument(((TradeHistoryParamCurrencyPair)params).getCurrencyPair());
        String to = params instanceof OkexTradeHistoryParams ? ((OkexTradeHistoryParams)params).getSinceOrderId() : null;
        String state = "2";
        String from = null;
        ArrayList<OkexOpenOrder> allOrdersWithTrades = new ArrayList<OkexOpenOrder>();
        boolean stop = false;
        do {
            List<OkexOpenOrder> l = this.getSpotOrderList(instrument, from, to, 100, "2");
            allOrdersWithTrades.addAll(l);
            boolean bl = stop = l.size() < 100;
            if (stop) continue;
            from = l.get(l.size() - 1).getOrderId();
        } while (!stop);
        ArrayList userTrades = new ArrayList();
        allOrdersWithTrades.forEach(o -> {
            try {
                this.fetchTradesForOrder((OkexOpenOrder)o).stream().filter(t -> Side.buy == t.getSide()).forEach(t -> {
                    CurrencyPair p = OkexAdaptersV3.toPair(t.getInstrumentId());
                    BigDecimal amount = null;
                    Currency feeCurrency = null;
                    if (o.getSide() == Side.buy) {
                        amount = t.getSize();
                        feeCurrency = p.base;
                    } else {
                        amount = OkexTradeService.stripTrailingZeros(t.getSize().divide(t.getPrice(), 16, RoundingMode.HALF_UP));
                        feeCurrency = p.counter;
                    }
                    UserTrade ut = new UserTrade.Builder().currencyPair(p).id(t.getLedgerId()).orderId(o.getOrderId()).originalAmount(amount).price(t.getPrice()).timestamp(t.getTimestamp()).type(o.getSide() == Side.buy ? Order.OrderType.BID : Order.OrderType.ASK).feeAmount(t.getFee()).feeCurrency(feeCurrency).build();
                    userTrades.add(ut);
                });
            }
            catch (IOException e) {
                throw new ExchangeException("Could not fetch transactions for " + o, (Throwable)e);
            }
        });
        Collections.sort(userTrades, (t1, t2) -> t1.getTimestamp().compareTo(t2.getTimestamp()));
        return new UserTrades(userTrades, Trades.TradeSortType.SortByTimestamp);
    }

    public UserTrades getMarginTradeHistory(TradeHistoryParams params) throws IOException {
        if (!(params instanceof TradeHistoryParamCurrencyPair)) {
            throw new UnsupportedOperationException("Getting open orders is only available for a single market.");
        }
        String instrument = OkexAdaptersV3.toSpotInstrument(((TradeHistoryParamCurrencyPair)params).getCurrencyPair());
        String to = params instanceof OkexTradeHistoryParams ? ((OkexTradeHistoryParams)params).getSinceOrderId() : null;
        String state = "2";
        String from = null;
        ArrayList<OkexOpenOrder> allOrdersWithTrades = new ArrayList<OkexOpenOrder>();
        boolean stop = false;
        do {
            List<OkexOpenOrder> l = this.getMarginOrderList(instrument, from, to, 100, "2");
            allOrdersWithTrades.addAll(l);
            boolean bl = stop = l.size() < 100;
            if (stop) continue;
            from = l.get(l.size() - 1).getOrderId();
        } while (!stop);
        ArrayList userTrades = new ArrayList();
        allOrdersWithTrades.forEach(o -> {
            try {
                this.fetchMarginTradesForOrder((OkexOpenOrder)o).stream().filter(t -> Side.buy == t.getSide()).forEach(t -> {
                    CurrencyPair p = OkexAdaptersV3.toPair(t.getInstrumentId());
                    BigDecimal amount = null;
                    Currency feeCurrency = null;
                    if (o.getSide() == Side.buy) {
                        amount = t.getSize();
                        feeCurrency = p.base;
                    } else {
                        amount = OkexTradeService.stripTrailingZeros(t.getSize().divide(t.getPrice(), 16, RoundingMode.HALF_UP));
                        feeCurrency = p.counter;
                    }
                    UserTrade ut = new UserTrade.Builder().currencyPair(p).id(t.getLedgerId()).orderId(o.getOrderId()).originalAmount(amount).price(t.getPrice()).timestamp(t.getTimestamp()).type(o.getSide() == Side.buy ? Order.OrderType.BID : Order.OrderType.ASK).feeAmount(t.getFee()).feeCurrency(feeCurrency).build();
                    userTrades.add(ut);
                });
            }
            catch (IOException e) {
                throw new ExchangeException("Could not fetch transactions for " + o, (Throwable)e);
            }
        });
        Collections.sort(userTrades, (t1, t2) -> t1.getTimestamp().compareTo(t2.getTimestamp()));
        return new UserTrades(userTrades, Trades.TradeSortType.SortByTimestamp);
    }

    private static BigDecimal stripTrailingZeros(BigDecimal bd) {
        bd = bd.stripTrailingZeros();
        bd = bd.setScale(Math.max(bd.scale(), 0));
        return bd;
    }

    private List<OkexTransaction> fetchTradesForOrder(OkexOpenOrder o) throws IOException {
        String from = null;
        ArrayList<OkexTransaction> all = new ArrayList<OkexTransaction>();
        boolean stop = false;
        do {
            List<OkexTransaction> l = this.getSpotTransactionDetails(o.getOrderId(), o.getInstrumentId(), from, null, null);
            all.addAll(l);
            boolean bl = stop = l.size() < 100;
            if (stop) continue;
            from = l.get(l.size() - 1).getLedgerId();
        } while (!stop);
        return all;
    }

    private List<OkexTransaction> fetchMarginTradesForOrder(OkexOpenOrder o) throws IOException {
        String from = null;
        ArrayList<OkexTransaction> all = new ArrayList<OkexTransaction>();
        boolean stop = false;
        do {
            List<OkexTransaction> l = this.getMarginTransactionDetails(o.getOrderId(), o.getInstrumentId(), from, null, null);
            all.addAll(l);
            boolean bl = stop = l.size() < 100;
            if (stop) continue;
            from = l.get(l.size() - 1).getLedgerId();
        } while (!stop);
        return all;
    }
}

