/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.okcoin.v3.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.okcoin.OkexExchangeV3;
import org.knowm.xchange.okcoin.v3.dto.account.FuturesLeverageResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesMultipleOrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesMultipleOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesOpenOrdersResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.FuturesOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexFuturesOpenOrder;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexFuturesTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexOpenOrder;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexSwapOpenOrder;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexSwapTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OkexTransaction;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderBatchCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.OrderPlacementResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SpotOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapFuturesMultipleOrderPlacementResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapMultipleOrderCancellationResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapMultipleOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapOpenOrdersResponse;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapOrderBatchCancellationRequest;
import org.knowm.xchange.okcoin.v3.dto.trade.SwapOrderPlacementRequest;
import org.knowm.xchange.okcoin.v3.service.OkexBaseService;
import si.mazi.rescu.ParamsDigest;

public class OkexTradeServiceRaw
extends OkexBaseService {
    protected OkexTradeServiceRaw(OkexExchangeV3 exchange) {
        super(exchange);
    }

    public OrderPlacementResponse spotPlaceOrder(SpotOrderPlacementRequest req) throws IOException {
        OrderPlacementResponse res = this.okex.spotPlaceOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public Map<String, List<OrderPlacementResponse>> spotPlaceMultipleOrders(List<SpotOrderPlacementRequest> req) throws IOException {
        return this.okex.spotPlaceMultipleOrders(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
    }

    public OrderCancellationResponse spotCancelOrder(String orderId, OrderCancellationRequest req) throws IOException {
        OrderCancellationResponse res = this.okex.spotCancelOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, orderId, req);
        res.checkResult();
        return res;
    }

    public Map<String, List<OrderCancellationResponse>> spotCancelMultipleOrders(List<OrderBatchCancellationRequest> req) throws IOException {
        return this.okex.spotCancelMultipleOrders(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
    }

    public List<OkexOpenOrder> getSpotOrderList(String instrumentId, String from, String to, Integer limit, String state) throws IOException {
        return this.okex.getSpotOrderList(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, from, to, limit, state);
    }

    public List<OkexTransaction> getSpotTransactionDetails(String orderId, String instrumentId, String from, String to, Integer limit) throws IOException {
        return this.okex.getSpotTransactionDetails(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, orderId, instrumentId, from, to, limit);
    }

    public List<OkexFuturesOpenOrder> getFuturesOrderList(String instrumentId, String from, String to, Integer limit, String state) throws IOException {
        FuturesOpenOrdersResponse res = this.okex.getFuturesOrderList(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, from, to, limit, state);
        res.checkResult();
        return res.getOrders();
    }

    public FuturesLeverageResponse getFuturesLeverage(String currency) throws IOException {
        FuturesLeverageResponse res = this.okex.getFuturesLeverage(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, currency);
        res.checkResult();
        return res;
    }

    public OrderPlacementResponse futuresPlaceOrder(FuturesOrderPlacementRequest req) throws IOException {
        OrderPlacementResponse res = this.okex.futuresPlaceOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public SwapFuturesMultipleOrderPlacementResponse futuresPlaceMultipleOrders(FuturesMultipleOrderPlacementRequest req) throws IOException {
        SwapFuturesMultipleOrderPlacementResponse res = this.okex.futuresPlaceMultipleOrders(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public OrderCancellationResponse futuresCancelOrder(String instrumentId, String orderId) throws IOException {
        OrderCancellationResponse res = this.okex.futuresCancelOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, orderId);
        res.checkResult();
        return res;
    }

    public FuturesMultipleOrderCancellationResponse futuresCancelMultipleOrders(String instrumentId, OrderBatchCancellationRequest req) throws IOException {
        FuturesMultipleOrderCancellationResponse res = this.okex.futuresCancelMultipleOrders(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, req);
        res.checkResult();
        return res;
    }

    public List<OkexFuturesTransaction> getFuturesTransactionDetails(String orderId, String instrumentId, String from, String to, Integer limit) throws IOException {
        return this.okex.getFuturesTransactionDetails(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, orderId, instrumentId, from, to, limit);
    }

    public List<OkexSwapOpenOrder> getSwapOrderList(String instrumentId, String from, String to, Integer limit, String state) throws IOException {
        SwapOpenOrdersResponse res = this.okex.getSwapOrderList(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, from, to, limit, state);
        res.checkResult();
        return res.getOrders();
    }

    public OrderPlacementResponse swapPlaceOrder(SwapOrderPlacementRequest req) throws IOException {
        OrderPlacementResponse res = this.okex.swapPlaceOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public SwapFuturesMultipleOrderPlacementResponse swapPlaceMultipleOrders(SwapMultipleOrderPlacementRequest req) throws IOException {
        SwapFuturesMultipleOrderPlacementResponse res = this.okex.swapPlaceMultipleOrders(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public OrderCancellationResponse swapCancelOrder(String instrumentId, String orderId) throws IOException {
        OrderCancellationResponse res = this.okex.swapCancelOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, orderId);
        res.checkResult();
        return res;
    }

    public SwapMultipleOrderCancellationResponse swapCancelMultipleOrders(String instrumentId, SwapOrderBatchCancellationRequest req) throws IOException {
        SwapMultipleOrderCancellationResponse res = this.okex.swapCancelMultipleOrders(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, req);
        res.checkResult();
        return res;
    }

    public List<OkexSwapTransaction> getSwapTransactionDetails(String orderId, String instrumentId, String from, String to, Integer limit) throws IOException {
        return this.okex.getSwapTransactionDetails(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, orderId, instrumentId, from, to, limit);
    }

    public OrderPlacementResponse marginPlaceOrder(SpotOrderPlacementRequest req) throws IOException {
        req.setMarginTrading("2");
        OrderPlacementResponse res = this.okex.marginPlaceOrder(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, req);
        res.checkResult();
        return res;
    }

    public List<OkexOpenOrder> getMarginOrderList(String instrumentId, String from, String to, Integer limit, String state) throws IOException {
        return this.okex.getMarginOrderList(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, instrumentId, from, to, limit, state);
    }

    public List<OkexTransaction> getMarginTransactionDetails(String orderId, String instrumentId, String from, String to, Integer limit) throws IOException {
        return this.okex.getMarginTransactionDetails(this.apikey, (ParamsDigest)this.digest, OkexTradeServiceRaw.timestamp(), this.passphrase, orderId, instrumentId, from, to, limit);
    }
}

