/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.knowm.xchange.poloniex.dto.PoloniexException;
import org.knowm.xchange.poloniex.dto.account.PoloniexBalance;
import org.knowm.xchange.poloniex.dto.account.PoloniexLoan;
import org.knowm.xchange.poloniex.dto.account.TransferResponse;
import org.knowm.xchange.poloniex.dto.account.WithdrawalResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexAccountBalance;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDepositsWithdrawalsResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexGenerateNewAddressResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMarginAccountResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMarginPostionResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexMoveResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexTradeResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="tradingApi")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public interface PoloniexAuthenticated {
    @POST
    @FormParam(value="command")
    public HashMap<String, PoloniexBalance> returnCompleteBalances(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="account") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public HashMap<String, PoloniexLoan[]> returnActiveLoans(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public HashMap<String, String> returnDepositAddresses(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexGenerateNewAddressResponse generateNewAddress(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currency") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public Map<String, PoloniexOpenOrder[]> returnOpenOrders(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currencyPair") AllPairs var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexUserTrade[] returnOrderTrades(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="orderNumber") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexOpenOrder[] returnOpenOrders(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currencyPair") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexUserTrade[] returnTradeHistory(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currencyPair") String var4, @FormParam(value="start") Long var5, @FormParam(value="end") Long var6, @FormParam(value="limit") Integer var7) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexMarginAccountResponse returnMarginAccountSummary(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexMarginPostionResponse getMarginPosition(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currencyPair") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public Map<String, PoloniexMarginPostionResponse> getMarginPosition(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currencyPair") AllPairs var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public HashMap<String, PoloniexUserTrade[]> returnTradeHistory(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currencyPair") String var4, @FormParam(value="start") Long var5, @FormParam(value="end") Long var6, @FormParam(value="limit") Integer var7, @FormParam(value="ignore") String var8) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexTradeResponse buy(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") String var4, @FormParam(value="rate") String var5, @FormParam(value="currencyPair") String var6, @FormParam(value="fillOrKill") Integer var7, @FormParam(value="immediateOrCancel") Integer var8, @FormParam(value="postOnly") Integer var9) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexTradeResponse sell(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") String var4, @FormParam(value="rate") String var5, @FormParam(value="currencyPair") String var6, @FormParam(value="fillOrKill") Integer var7, @FormParam(value="immediateOrCancel") Integer var8, @FormParam(value="postOnly") Integer var9) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexTradeResponse marginBuy(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") String var4, @FormParam(value="rate") String var5, @FormParam(value="currencyPair") String var6, @FormParam(value="lendingRate") Double var7) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexTradeResponse marginSell(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") String var4, @FormParam(value="rate") String var5, @FormParam(value="currencyPair") String var6, @FormParam(value="lendingRate") Double var7) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexMoveResponse moveOrder(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="orderNumber") String var4, @FormParam(value="amount") String var5, @FormParam(value="rate") String var6, @FormParam(value="immediateOrCancel") Integer var7, @FormParam(value="postOnly") Integer var8) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public HashMap<String, String> cancelOrder(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="orderNumber") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public WithdrawalResponse withdraw(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currency") String var4, @FormParam(value="amount") BigDecimal var5, @FormParam(value="address") String var6, @FormParam(value="paymentId") @Nullable String var7) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public TransferResponse transferBalance(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="currency") String var4, @FormParam(value="amount") BigDecimal var5, @FormParam(value="fromAccount") String var6, @FormParam(value="toAccount") String var7) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public HashMap<String, String> returnFeeInfo(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexAccountBalance returnAvailableAccountBalances(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @Nullable @FormParam(value="account") String var4) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public Map<String, Map<String, BigDecimal>> returnTradableBalances(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexAccountBalance[] returnAvailableAccountBalances(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws PoloniexException, IOException;

    @POST
    @FormParam(value="command")
    public PoloniexDepositsWithdrawalsResponse returnDepositsWithdrawals(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="start") Long var4, @FormParam(value="end") Long var5) throws PoloniexException, IOException;

    public static enum AllPairs {
        all;

    }
}

